/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.service;

import bld.commons.exception.PropertiesException;
import bld.commons.reflection.model.BuildJpqlQueryParameter;
import bld.commons.reflection.model.BuildNativeQueryParameter;
import bld.commons.reflection.model.NativeQueryParameter;
import bld.commons.reflection.model.QueryParameter;
import bld.commons.reflection.utils.ReflectionCommons;
import bld.commons.service.BaseJpaService;
import bld.commons.service.JpaService;
import bld.commons.service.QueryJpql;
import bld.commons.utils.PersistenceMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Id;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;

public abstract class JpaServiceImpl<T, ID>
extends BaseJpaService<T, ID>
implements JpaService<T, ID> {
    private static final String POINT = "\\.";
    private Field id = null;
    @Autowired
    protected ReflectionCommons reflectionCommons;
    @Autowired
    protected QueryJpql<T> queryJpl;

    protected Field getId() {
        return this.id;
    }

    public JpaServiceImpl() {
        Set<Field> fields = ReflectionCommons.getListField(this.getClassEntity());
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Id.class)) continue;
            this.id = field;
            break;
        }
    }

    protected abstract JpaRepository<T, ID> getJpaRepository();

    private BuildJpqlQueryParameter<T, ID> configureQueryParameter(Map<String, String> mapConditions, Map<String, String> mapOrders, QueryParameter<T, ID> queryParameter, String query) {
        if (MapUtils.isEmpty(this.getMapOneToMany())) {
            this.setMapOneToMany();
        }
        if (queryParameter.getBaseParameter() != null) {
            queryParameter = this.reflectionCommons.dataToMap(queryParameter);
        }
        return new BuildJpqlQueryParameter<T, ID>(mapConditions, mapOrders, queryParameter, query);
    }

    private void setMapOneToMany() {
        super.setMapOneToMany(this.queryJpl.getMapOneToMany());
    }

    private String selectByFilter() {
        return this.queryJpl.selectByFilter();
    }

    private String selectIdByFilter() {
        return this.queryJpl.selectIdByFilter();
    }

    private String deleteByFilter() {
        return this.queryJpl.deleteByFilter();
    }

    private String countByFilter() {
        return this.queryJpl.countByFilter();
    }

    @Override
    public long count() {
        return this.getJpaRepository().count();
    }

    @Override
    public void delete(T entity) {
        this.getJpaRepository().delete(entity);
    }

    @Override
    public void deleteAll(Collection<T> entities) {
        if (CollectionUtils.isNotEmpty(entities)) {
            this.getJpaRepository().deleteAll(entities);
        }
    }

    @Override
    public T findById(ID id) {
        return this.getJpaRepository().findById(id).orElse(null);
    }

    @Override
    public List<T> findAll() {
        return this.getJpaRepository().findAll();
    }

    @Override
    public void save(T entity) {
        this.getJpaRepository().save(entity);
    }

    @Override
    public T update(T entity) {
        return (T)this.getJpaRepository().save(entity);
    }

    @Override
    public void saveAndFlush(T entity) {
        this.getJpaRepository().saveAndFlush(entity);
    }

    @Override
    public T updateAndFlush(T entity) {
        this.getJpaRepository().save(entity);
        this.getJpaRepository().flush();
        return entity;
    }

    @Override
    public void deleteAndFlush(T entity) {
        this.getJpaRepository().delete(entity);
        this.getJpaRepository().flush();
    }

    @Override
    public void saveAll(Collection<T> listT) {
        if (!CollectionUtils.isEmpty(listT)) {
            this.getJpaRepository().saveAll(listT);
        }
    }

    @Override
    public void flush() {
        this.getJpaRepository().flush();
    }

    @Override
    public void deleteById(ID id) {
        this.getJpaRepository().deleteById(id);
    }

    protected void addJoinOneToMany(String key, String ... join) {
        if (!this.getMapOneToMany().containsKey(key)) {
            this.getMapOneToMany().put(key, new LinkedHashSet());
        }
        this.getMapOneToMany().get(key).addAll(Arrays.asList(join));
    }

    @Override
    public List<T> findByFilter(QueryParameter<T, ID> queryParameter) {
        return this.findByFilter(queryParameter, this.selectByFilter());
    }

    @Override
    public T singleResultByFilter(QueryParameter<T, ID> queryParameter) {
        return this.singleResultByFilter(queryParameter, this.selectByFilter());
    }

    @Override
    public T singleResultByFilter(QueryParameter<T, ID> queryParameter, String select) {
        BuildJpqlQueryParameter<T, ID> buildQueryFilter = this.configureQueryParameter(this.queryJpl.mapConditions(), new HashMap<String, String>(), queryParameter, select);
        return super.findSingleResultByFilter(buildQueryFilter);
    }

    @Override
    public Long countByFilter(QueryParameter<T, ID> queryParameter) {
        return this.countByFilter(queryParameter, this.countByFilter());
    }

    @Override
    public List<T> findByFilter(QueryParameter<T, ID> queryParameter, String select) {
        BuildJpqlQueryParameter<T, ID> buildQueryFilter = this.configureQueryParameter(this.queryJpl.mapConditions(), this.queryJpl.mapJpaOrders(), queryParameter, select);
        return super.findByFilter(buildQueryFilter);
    }

    @Override
    public Long countByFilter(QueryParameter<T, ID> queryParameter, String count) {
        BuildJpqlQueryParameter<T, ID> buildQueryFilter = this.configureQueryParameter(this.queryJpl.mapConditions(), new HashMap<String, String>(), queryParameter, count);
        return super.countByFilter(buildQueryFilter);
    }

    @Override
    public void deleteByFilter(QueryParameter<T, ID> queryParameter) {
        BuildJpqlQueryParameter<T, ID> buildQueryFilter = this.configureQueryParameter(this.queryJpl.mapConditions(), new HashMap<String, String>(), queryParameter, this.selectIdByFilter());
        List<ID> ids = super.findIdByFilter(buildQueryFilter);
        if (CollectionUtils.isNotEmpty(ids)) {
            QueryParameter qp = new QueryParameter();
            qp.addParameter("id", ids);
            buildQueryFilter = this.configureQueryParameter(this.queryJpl.mapDeleteConditions(), new HashMap<String, String>(), qp, this.deleteByFilter());
            super.deleteByFilter(buildQueryFilter);
        }
    }

    @Override
    public Map<ID, T> mapFindByFilter(QueryParameter<T, ID> queryParameter) {
        List<T> list = this.findByFilter(queryParameter);
        return this.mapIdEntity(list);
    }

    private Map<ID, T> mapIdEntity(List<T> list) {
        HashMap<Object, T> map = new HashMap<Object, T>();
        for (T t : list) {
            try {
                map.put(PropertyUtils.getProperty(t, this.id.getName()), t);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new PropertiesException(e);
            }
        }
        return map;
    }

    @Override
    public Map<ID, T> mapFindByFilter(QueryParameter<T, ID> queryParameter, String sql) {
        List<T> list = this.findByFilter(queryParameter, sql);
        return this.mapIdEntity(list);
    }

    private Object getKey(String[] fields, T t) {
        Object value = t;
        for (String field : fields) {
            try {
                value = PropertyUtils.getProperty(value, field);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new PropertiesException(e);
            }
        }
        return value;
    }

    private <J> PersistenceMap<J, T> mapKeyEntity(List<T> list, Class<J> classKey, String key) {
        PersistenceMap<Object, T> map = new PersistenceMap<Object, T>();
        String[] fields = key.split(POINT);
        for (T t : list) {
            map.put(this.getKey(fields, t), t);
        }
        return map;
    }

    @Override
    public <J> PersistenceMap<J, T> mapKeyFindByFilter(QueryParameter<T, ID> queryParameter, Class<J> classKey, String key) {
        List<T> list = this.findByFilter(queryParameter);
        return this.mapKeyEntity(list, classKey, key);
    }

    @Override
    public <J> PersistenceMap<J, T> mapKeyFindByFilter(QueryParameter<T, ID> queryParameter, String sql, Class<J> classKey, String key) {
        List<T> list = this.findByFilter(queryParameter, sql);
        return this.mapKeyEntity(list, classKey, key);
    }

    private <J> PersistenceMap<J, List<T>> mapKeyListEntity(List<T> list, Class<J> classKey, String keyFields) {
        PersistenceMap map = new PersistenceMap();
        String[] fields = keyFields.split(POINT);
        for (T t : list) {
            Object key = this.getKey(fields, t);
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            ((List)map.get(this.getKey(fields, t))).add(t);
        }
        return map;
    }

    @Override
    public <J> PersistenceMap<J, List<T>> mapKeyListFindByFilter(QueryParameter<T, ID> queryParameter, Class<J> classKey, String key) {
        List<T> list = this.findByFilter(queryParameter);
        return this.mapKeyListEntity(list, classKey, key);
    }

    @Override
    public <J> PersistenceMap<J, List<T>> mapKeyListFindByFilter(QueryParameter<T, ID> queryParameter, String sql, Class<J> classKey, String key) {
        List<T> list = this.findByFilter(queryParameter, sql);
        return this.mapKeyListEntity(list, classKey, key);
    }

    @Override
    public <K> List<K> findByFilter(NativeQueryParameter<K, ID> queryParameter, String sql) {
        BuildNativeQueryParameter<K, ID> buildQueryFilter = this.getBuildNativeQueryFilter(queryParameter, sql);
        return super.findByFilter(buildQueryFilter);
    }

    @Override
    public <K> Long countByFilter(NativeQueryParameter<K, ID> queryParameter, String count) {
        BuildNativeQueryParameter<K, ID> buildQueryFilter = this.getBuildNativeQueryFilter(queryParameter, count);
        return this.nativeQueryCountByFilter(buildQueryFilter);
    }

    private <K> BuildNativeQueryParameter<K, ID> getBuildNativeQueryFilter(NativeQueryParameter<K, ID> queryParameter, String sql) {
        if (queryParameter.getBaseParameter() != null) {
            queryParameter = this.reflectionCommons.dataToMap(queryParameter);
        }
        BuildNativeQueryParameter<K, ID> buildQueryFilter = new BuildNativeQueryParameter<K, ID>(this.queryJpl.mapNativeConditions(), this.queryJpl.mapNativeOrders(), queryParameter, sql);
        return buildQueryFilter;
    }

    @Override
    public <K> K singleResultByFilter(NativeQueryParameter<K, ID> queryParameter, String sql) {
        BuildNativeQueryParameter<K, ID> buildQueryFilter = this.getBuildNativeQueryFilter(queryParameter, sql);
        List<K> list = ((BaseJpaService)this).findByFilter(buildQueryFilter);
        K k = null;
        if (list.size() > 1) {
            throw new RuntimeException("Find multiple record");
        }
        if (list != null) {
            k = list.get(0);
        }
        return k;
    }
}

