/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.utils.json.annotations.deserialize;

import com.bld.commons.utils.json.annotations.CleanExcessSpaces;
import com.bld.commons.utils.json.annotations.deserialize.data.CleanExcessSpacesProps;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

@JacksonStdImpl
public class CleanExcessSpacesDeserialize
extends StdScalarDeserializer<String>
implements ContextualDeserializer {
    private CleanExcessSpacesProps cleanExcessSpacesProps;

    public CleanExcessSpacesDeserialize() {
        super(String.class);
    }

    protected CleanExcessSpacesDeserialize(Class<String> src, CleanExcessSpacesProps maxConsecutiveSpaceProps) {
        super(src);
        this.cleanExcessSpacesProps = maxConsecutiveSpaceProps;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        CleanExcessSpaces cleanExcessSpaces = (CleanExcessSpaces)property.getAnnotation(CleanExcessSpaces.class);
        CleanExcessSpacesProps cleanExcessSpacesProps = new CleanExcessSpacesProps(cleanExcessSpaces.consecutive(), cleanExcessSpaces.trim(), cleanExcessSpaces.removeEndline(), cleanExcessSpaces.removeAllSpaceType(), cleanExcessSpaces.upperLowerType(), cleanExcessSpaces.removeTab());
        return new CleanExcessSpacesDeserialize(String.class, cleanExcessSpacesProps);
    }

    public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String text = p.getText();
        if (StringUtils.isNotEmpty(text)) {
            if (this.cleanExcessSpacesProps.isRemoveAllSpaceType()) {
                text = text.replaceAll("\\s+", "");
            } else {
                if (this.cleanExcessSpacesProps.isRemoveEndline()) {
                    text = text.replace("\n", "");
                }
                if (this.cleanExcessSpacesProps.isRemoveTab()) {
                    text = text.replace("\t", "");
                }
                if (this.cleanExcessSpacesProps.isTrim()) {
                    text = text.trim();
                }
                String space = "";
                for (int i = 0; i < this.cleanExcessSpacesProps.getConsecutive(); ++i) {
                    space = space + " ";
                }
                text = this.removeSpace(space + " ", space, text);
            }
            switch (this.cleanExcessSpacesProps.getUpperLowerType()) {
                case LOWER: {
                    text = text.toLowerCase();
                    break;
                }
                case UPPER: {
                    text = text.toUpperCase();
                    break;
                }
            }
        }
        return text;
    }

    private String removeSpace(String remveText, String replaceText, String text) {
        if (text.contains(remveText)) {
            text = this.removeSpace(remveText, replaceText, text.replace(remveText, replaceText));
        }
        return text;
    }
}

