/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.utils.json.annotations.serialize;

import com.bld.commons.utils.DateUtils;
import com.bld.commons.utils.json.annotations.DateTimeZone;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.AbstractEnvironment;

@JacksonStdImpl
public class DateSerializer<T>
extends StdScalarSerializer<T>
implements ContextualSerializer {
    @Autowired
    private AbstractEnvironment env = null;
    protected DateTimeZone dateTimeZone = null;
    private SimpleDateFormat simpleDateFormat = null;

    public DateSerializer() {
        this(null);
    }

    private DateSerializer(Class<T> t) {
        super(t);
    }

    private DateSerializer(Class<T> t, AbstractEnvironment env) {
        super(t);
        this.env = env;
    }

    private DateSerializer(Class<T> classDate, DateTimeZone dateTimeZone, SimpleDateFormat simpleDateFormat, AbstractEnvironment env) {
        super(classDate);
        this.dateTimeZone = dateTimeZone;
        this.simpleDateFormat = simpleDateFormat;
        this.env = env;
    }

    public String formatDate(T date) {
        String dateString = null;
        if (date instanceof Calendar) {
            dateString = this.simpleDateFormat.format(DateUtils.calendarToDate((Calendar)date));
        } else if (date instanceof Date) {
            dateString = this.simpleDateFormat.format((Date)date);
        } else if (date instanceof Timestamp) {
            dateString = this.simpleDateFormat.format(DateUtils.timestampToDate((Timestamp)date));
        }
        return dateString;
    }

    public void serialize(T date, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(this.formatDate(date));
    }

    private void setSimpleDateFormat(TimeZone timeZone, String format) {
        this.simpleDateFormat = new SimpleDateFormat(format);
        this.simpleDateFormat.setTimeZone(timeZone);
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        this.dateTimeZone = (DateTimeZone)property.getAnnotation(DateTimeZone.class);
        if (this.dateTimeZone.timeZone().startsWith("${") && this.dateTimeZone.timeZone().endsWith("}")) {
            TimeZone timeZone = TimeZone.getDefault();
            String tz = this.env.resolvePlaceholders(this.dateTimeZone.timeZone());
            if (StringUtils.isNotBlank(tz) && !tz.equals(this.dateTimeZone.timeZone())) {
                timeZone = TimeZone.getTimeZone(tz);
            }
            this.setSimpleDateFormat(timeZone, this.dateTimeZone.format());
        } else {
            this.setSimpleDateFormat(TimeZone.getTimeZone(this.dateTimeZone.timeZone()), this.dateTimeZone.format());
        }
        if (property.getType() != null && property.getType().getRawClass() != null) {
            return new DateSerializer<T>(property.getType().getRawClass(), this.dateTimeZone, this.simpleDateFormat, this.env);
        }
        return this;
    }
}

