/*
 * Decompiled with CFR 0.152.
 */
package com.github.bogdan5555556.CucumberStepsConsoleLogger;

import com.github.bogdan5555556.CucumberStepsConsoleLogger.Colours;
import cucumber.runtime.StepDefinitionMatch;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberStepsConsoleLogger
implements Reporter,
Formatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CucumberStepsConsoleLogger.class);
    private static final String ANSI_MAGENTA = "\u001b[35m";
    private static final String ANSI_RESET = "\u001b[0m";
    private List<Step> steps = new ArrayList<Step>();
    private Colours colour;

    public CucumberStepsConsoleLogger() {
        String colour = System.getenv("CucumberStepsConsoleLoggerColour");
        this.colour = colour == null ? Colours.DEFAULT : Colours.byName(colour.toUpperCase());
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    public void uri(String uri) {
    }

    public void feature(Feature feature) {
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
    }

    public void examples(Examples examples) {
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
    }

    public void background(Background background) {
    }

    public void scenario(Scenario scenario) {
    }

    public void step(Step step) {
        this.steps.add(step);
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
    }

    public void done() {
    }

    public void close() {
    }

    public void eof() {
    }

    public void before(Match match, Result result) {
    }

    public void result(Result result) {
    }

    public void after(Match match, Result result) {
    }

    public void match(Match match) {
        Step step = null;
        String stepName = ((StepDefinitionMatch)match).getStepName();
        for (Step step1 : this.steps) {
            if (!step1.getName().equals(stepName)) continue;
            step = step1;
        }
        String stepLogName = step.getKeyword() + " " + step.getName();
        if (step.getRows() != null) {
            for (DataTableRow dataTableRow : step.getRows()) {
                stepLogName = stepLogName + "\n";
                for (String cell : dataTableRow.getCells()) {
                    stepLogName = stepLogName + "\t|\t" + cell;
                }
                stepLogName = stepLogName + "\t|\t";
            }
        }
        if (step.getDocString() != null) {
            stepLogName = stepLogName + "\n";
            stepLogName = stepLogName + "'''" + "\n" + step.getDocString().getValue() + "\n" + "'''";
        }
        LOGGER.info(this.buildStepExecutionMessage(stepLogName));
    }

    private String buildStepExecutionMessage(String stepLogName) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n\n---------- Test Step Execution ----------\n");
        this.colour.appendTo(stringBuilder);
        stringBuilder.append(stepLogName);
        Colours.RESET.appendTo(stringBuilder);
        stringBuilder.append("\n---------- Test Step Execution ----------\n");
        return stringBuilder.toString();
    }

    public void embedding(String mimeType, byte[] data) {
    }

    public void write(String text) {
    }
}

