/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.taskmaster.cache.impl;

import com.github.bordertech.taskmaster.cache.CachingHelperProvider;
import com.github.bordertech.taskmaster.cache.impl.CachingProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Singleton
public class CachingHelperProviderDefault
implements CachingHelperProvider {
    private static final Log LOGGER = LogFactory.getLog(CachingHelperProviderDefault.class);
    private final CacheManager cacheManager;

    public CachingHelperProviderDefault() {
        URI uri = this.checkXMLConfig();
        this.cacheManager = uri == null ? Caching.getCachingProvider().getCacheManager() : Caching.getCachingProvider().getCacheManager(uri, CachingHelperProviderDefault.class.getClassLoader());
    }

    protected final URI checkXMLConfig() {
        String config = CachingProperties.getConfigXmlLocation();
        if (StringUtils.isBlank((CharSequence)config)) {
            LOGGER.info((Object)"No XML cache config property set. Will use cache provider default config.");
            return null;
        }
        try {
            URL url = CachingHelperProviderDefault.class.getResource(config);
            if (url == null) {
                LOGGER.info((Object)("Could not find XML cache config [" + config + "] on classpath. Will use cache provider default config."));
                return null;
            }
            LOGGER.info((Object)("XML cache config [" + config + "] found on classpath and will be used for the cache manager config."));
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Could not load XML cache config [" + config + "]. " + e.getMessage(), e);
        }
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public synchronized void closeCacheManager() {
        if (!this.getCacheManager().isClosed()) {
            this.getCacheManager().close();
        }
    }

    @Override
    public synchronized <K, V> Cache<K, V> getOrCreateCache(String name, Class<K> keyClass, Class<V> valueClass) {
        Cache<K, V> cache = this.getCacheManager().getCache(name, keyClass, valueClass);
        if (cache == null) {
            Duration duration = CachingProperties.getCacheDuration(name);
            cache = this.createCache(name, keyClass, valueClass, duration);
        }
        return cache;
    }

    @Override
    public synchronized <K, V> Cache<K, V> getOrCreateCache(String name, Class<K> keyClass, Class<V> valueClass, Duration duration) {
        Cache<K, V> cache = this.getCacheManager().getCache(name, keyClass, valueClass);
        if (cache == null) {
            Duration durationOverride = CachingProperties.getCacheDuration(name, duration);
            cache = this.createCache(name, keyClass, valueClass, durationOverride);
        }
        return cache;
    }

    @Override
    public synchronized <K, V> Cache<K, V> getOrCreateCache(String name, Class<K> keyClass, Class<V> valueClass, Configuration<K, V> config) {
        Cache cache = this.getCacheManager().getCache(name, keyClass, valueClass);
        if (cache == null) {
            cache = this.getCacheManager().createCache(name, config);
        }
        return cache;
    }

    protected synchronized <K, V> Cache<K, V> createCache(String name, Class<K> keyClass, Class<V> valueClass, Duration duration) {
        MutableConfiguration config = new MutableConfiguration();
        config.setTypes(keyClass, valueClass);
        config.setExpiryPolicyFactory(AccessedExpiryPolicy.factoryOf((Duration)duration));
        return this.getCacheManager().createCache(name, (Configuration)config);
    }
}

