/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.taskmaster.cache.impl;

import com.github.bordertech.config.Config;
import java.util.concurrent.TimeUnit;
import javax.cache.expiry.Duration;
import org.apache.commons.configuration.Configuration;

public final class CachingProperties {
    private static final String DEFAULT_PREFIX = "bordertech.taskmaster.cache.default.";
    private static final String AMOUNT = "amount";
    private static final String UNIT = "unit";

    private CachingProperties() {
    }

    public static String getConfigXmlLocation() {
        return CachingProperties.getConfig().getString("bordertech.taskmaster.cache.config", "/tm-cache.xml");
    }

    public static Duration getDefaultDuration() {
        return new Duration(CachingProperties.getDefaultDurationUnit(), CachingProperties.getDefaultDurationAmount().longValue());
    }

    public static Duration getCacheDuration(String cacheName) {
        return CachingProperties.getCacheDuration(cacheName, CachingProperties.getDefaultDuration());
    }

    public static Duration getCacheDuration(String cacheName, Duration defaultDuration) {
        TimeUnit unit = CachingProperties.getCacheDurationUnit(cacheName, defaultDuration.getTimeUnit());
        Long amount = CachingProperties.getCacheDurationAmount(cacheName, defaultDuration.getDurationAmount());
        return new Duration(unit, amount.longValue());
    }

    private static Long getDefaultDurationAmount() {
        return CachingProperties.getConfig().getLong("bordertech.taskmaster.cache.default.amount", Long.valueOf("1800"));
    }

    private static TimeUnit getDefaultDurationUnit() {
        String paramUnit = CachingProperties.getConfig().getString("bordertech.taskmaster.cache.default.unit");
        return CachingProperties.convertParamToTimeUnit(paramUnit, TimeUnit.SECONDS);
    }

    private static Long getCacheDurationAmount(String cacheName, Long defaultAmount) {
        return CachingProperties.getConfig().getLong(CachingProperties.getCachePrefix(cacheName) + AMOUNT, defaultAmount);
    }

    private static TimeUnit getCacheDurationUnit(String cacheName, TimeUnit defaultUnit) {
        String paramUnit = CachingProperties.getConfig().getString(CachingProperties.getCachePrefix(cacheName) + UNIT);
        return CachingProperties.convertParamToTimeUnit(paramUnit, defaultUnit);
    }

    private static String getCachePrefix(String cacheName) {
        return "bordertech.taskmaster.cache." + cacheName + ".duration.";
    }

    private static TimeUnit convertParamToTimeUnit(String paramUnit, TimeUnit defaultUnit) {
        if (paramUnit == null) {
            return defaultUnit;
        }
        switch (paramUnit) {
            case "d": {
                return TimeUnit.DAYS;
            }
            case "h": {
                return TimeUnit.HOURS;
            }
            case "m": {
                return TimeUnit.MINUTES;
            }
            case "s": {
                return TimeUnit.SECONDS;
            }
            case "mi": {
                return TimeUnit.MILLISECONDS;
            }
        }
        return defaultUnit;
    }

    private static Configuration getConfig() {
        return Config.getInstance();
    }
}

