package com.github.bordertech.wcomponents.examples.theme;

import com.github.bordertech.wcomponents.Action;
import com.github.bordertech.wcomponents.ActionEvent;
import com.github.bordertech.wcomponents.WButton;
import com.github.bordertech.wcomponents.WContainer;
import com.github.bordertech.wcomponents.WField;
import com.github.bordertech.wcomponents.WFieldLayout;
import com.github.bordertech.wcomponents.WHeading;
import com.github.bordertech.wcomponents.WHiddenComment;
import com.github.bordertech.wcomponents.WStyledText;
import com.github.bordertech.wcomponents.WStyledText.WhitespaceMode;
import com.github.bordertech.wcomponents.WTextArea;

/**
 * Example showing how to use the {@link WHiddenComment} component.
 *
 * @author Jonathan Austin
 * @since 1.0.0
 */
public class WHiddenCommentExample extends WContainer {

	/**
	 * Hidden comment.
	 */
	private final WHiddenComment comment1 = new WHiddenComment("This is a hidden comment.");
	/**
	 * Comment that can be generated by entering text in the UI.
	 */
	private final WHiddenComment comment2 = new WHiddenComment();
	/**
	 * Text entered into this field is used a comment.
	 */
	private final WTextArea textComment = new WTextArea();

	/**
	 * Create the WHiddenComment example.
	 */
	public WHiddenCommentExample() {
		add(new WHeading(WHeading.SECTION, "Hidden Comments Example"));
		WStyledText text = new WStyledText(
				"Right click the page to view the source and the hidden comments.");
		text.setWhitespaceMode(WhitespaceMode.PARAGRAPHS);
		add(text);
		textComment.setRows(5);
		WFieldLayout layout = new WFieldLayout();
		WField field = layout.addField("Enter text to be hidden as a comment", textComment);
		field.setInputWidth(100);
		add(layout);
		WButton button = new WButton("Submit");
		button.setAction(new Action() {
			@Override
			public void execute(final ActionEvent event) {
				comment2.setText(textComment.getText());
			}
		});

		add(comment1);
		add(comment2);
		add(button);
	}

}
