/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples;

import com.github.bordertech.wcomponents.WButton;
import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.examples.SeleniumTests;
import com.github.bordertech.wcomponents.examples.WComponentExamplesTestCase;
import com.github.bordertech.wcomponents.examples.WDialogExample;
import com.github.bordertech.wcomponents.test.selenium.ByWComponent;
import com.github.bordertech.wcomponents.test.selenium.MultiBrowserRunner;
import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriver;
import junit.framework.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;

@Category(value={SeleniumTests.class})
@RunWith(value=MultiBrowserRunner.class)
public class WDialogExample_Test
extends WComponentExamplesTestCase {
    public WDialogExample_Test() {
        super((WComponent)new WDialogExample());
    }

    @Test
    public void testModalDialogNotPresentOnLoad() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        WDialogExample example = (WDialogExample)this.getUi();
        String expectedText = example.getModalText();
        Assert.assertFalse((String)"Should not be displaying the dialog", (boolean)driver.getPageSource().contains(expectedText));
    }

    @Test
    public void testModalDialog() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        WDialogExample example = (WDialogExample)this.getUi();
        String expectedText = example.getModalText();
        WButton testButton = example.getModalButton();
        driver.findElement((By)this.byWComponent((WComponent)testButton)).click();
        Assert.assertTrue((String)"Should be displaying the dialog", (boolean)driver.getPageSource().contains(expectedText));
    }

    @Test
    public void testModalDialogCloseOnCancel() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        WDialogExample example = (WDialogExample)this.getUi();
        String expectedText = example.getModalText();
        WButton testButton = example.getModalButton();
        driver.findElement(this.byWComponent((WComponent)testButton)).click();
        Assert.assertTrue((String)"Dialog must be open.", (boolean)driver.getDialog().isOpen());
        driver.getDialog().close();
        Assert.assertFalse((String)"Should not be displaying the dialog", (boolean)driver.isOpenDialog());
        Assert.assertFalse((String)"Should not be displaying the dialog", (boolean)driver.getPageSource().contains(expectedText));
    }

    @Test
    public void testModalDialogSearch() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        WDialogExample example = (WDialogExample)this.getUi();
        WButton testButton = example.getModalButton();
        driver.findElement(this.byWComponent((WComponent)testButton)).click();
        driver.findWTextField((By)this.byWComponentPath("WDialogExample$SelectPersonPanel/WTextField[0]")).sendKeys(new CharSequence[]{"First"});
        driver.findWTextField((By)this.byWComponentPath("WDialogExample$SelectPersonPanel/WTextField[1]")).sendKeys(new CharSequence[]{"Last"});
        driver.findElement((ByWComponent)this.byWComponentPath("WDialogExample$SelectPersonPanel/WButton[2]")).click();
        driver.findElement((ByWComponent)this.byWComponentPath("WDialogExample$SelectPersonPanel/WRadioButtonSelect", "Last, First")).click();
        driver.findElement((ByWComponent)this.byWComponentPath("WDialogExample$SelectPersonPanel/WButton[1]")).click();
        String message = driver.findElement((ByWComponent)this.byWComponentPath("WMessageBox")).getText();
        Assert.assertTrue((String)"Incorrect message text", (boolean)message.contains("Selected: Last, First"));
    }

    @Test
    public void testModelessDialogNotPresentOnLoad() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        WDialogExample example = (WDialogExample)this.getUi();
        String expectedText = example.getNonModalText();
        Assert.assertFalse((String)"Should not be displaying the dialog", (boolean)driver.getPageSource().contains(expectedText));
    }

    @Test
    public void testModelessDialog() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        WDialogExample example = (WDialogExample)this.getUi();
        String expectedText = example.getNonModalText();
        WButton testButton = example.getNonModalButton();
        driver.findElement((By)this.byWComponent((WComponent)testButton)).click();
        Assert.assertTrue((String)"Should not be displaying the dialog", (boolean)driver.getPageSource().contains(expectedText));
    }
}

