/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples.petstore;

import com.github.bordertech.wcomponents.Request;
import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.WebUtilities;
import com.github.bordertech.wcomponents.examples.petstore.InventoryCostRenderer;
import com.github.bordertech.wcomponents.examples.petstore.model.InventoryBean;
import com.github.bordertech.wcomponents.util.mock.MockRequest;
import org.junit.Assert;
import org.junit.Test;

public class InventoryCostRenderer_Test {
    private static final String EXPECTED_VALUE_FROM_NULL_BEAN_VALUE = "$-.--";
    private static final String SPECIAL_STATUS_ALERT = System.getProperty("line.separator") + "<ui:text type=\"emphasised\"> -- on special!</ui:text>";

    @Test
    public void testGetTextNull() {
        InventoryCostRenderer renderer = new InventoryCostRenderer();
        String renderedText = this.renderToString(renderer);
        Assert.assertEquals((String)"should return $string without values filled", (Object)EXPECTED_VALUE_FROM_NULL_BEAN_VALUE, (Object)renderedText);
    }

    @Test
    public void testGetTextInventoryBean() {
        boolean testProductId = true;
        boolean testStatus = true;
        int testCount = 12;
        int testUnitCost = 2456;
        String expectedTestResult = "$24.56";
        InventoryCostRenderer renderer = new InventoryCostRenderer();
        renderer.setBean((Object)new InventoryBean(1, 1, 12, 2456));
        renderer.setBeanProperty(".");
        String renderedText = this.renderToString(renderer);
        Assert.assertEquals((String)"should return expected dollar value", (Object)"$24.56", (Object)renderedText);
    }

    @Test
    public void testGetTextInventoryBeanStatusSpecial() {
        boolean testProductId = true;
        int testStatus = 3;
        int testCount = 12;
        int testUnitCost = 5432;
        String expectedTestResult = "$54.32" + SPECIAL_STATUS_ALERT;
        InventoryCostRenderer renderer = new InventoryCostRenderer();
        renderer.setBean((Object)new InventoryBean(1, 3, 12, 5432));
        renderer.setBeanProperty(".");
        String renderedText = this.renderToString(renderer);
        Assert.assertEquals((String)"should return expected dollar value", (Object)expectedTestResult, (Object)renderedText);
    }

    private String renderToString(InventoryCostRenderer renderer) {
        return WebUtilities.render((Request)new MockRequest(), (WComponent)renderer);
    }
}

