/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples.petstore;

import com.github.bordertech.wcomponents.examples.petstore.InventoryCountRenderer;
import com.github.bordertech.wcomponents.examples.petstore.model.InventoryBean;
import org.junit.Assert;
import org.junit.Test;

public class InventoryCountRenderer_Test {
    private static final String EXPECTED_VALUE_FROM_NULL_BEAN_VALUE = "";
    private static final String TEST_RESULT_STATUS_NO_LONGER_AVALIABLE = "No longer available";
    private static final String TEST_RESULT_STATUS_NEW = "Coming soon";
    private static final String TEST_RESULT_STATUS_OTHER = "Sold out";

    @Test
    public void testGetTextNull() {
        InventoryCountRenderer renderer = new InventoryCountRenderer();
        String renderedText = renderer.getText();
        Assert.assertEquals((String)"should return $string without values filled", (Object)EXPECTED_VALUE_FROM_NULL_BEAN_VALUE, (Object)renderedText);
    }

    @Test
    public void testGetTextPositiveCount() {
        InventoryCountRenderer renderer = new InventoryCountRenderer();
        boolean testProductId = true;
        int testStatus = 3;
        int testCount = 12;
        int testUnitCost = 5432;
        String expectedTestResult = String.valueOf(12);
        renderer.setBean((Object)new InventoryBean(1, 3, 12, 5432));
        renderer.setBeanProperty(".");
        String renderedText = renderer.getText();
        Assert.assertEquals((String)"should return testCount as String", (Object)expectedTestResult, (Object)renderedText);
    }

    @Test
    public void testGetTextZeroCountNoLongerAvailable() {
        InventoryCountRenderer renderer = new InventoryCountRenderer();
        boolean testProductId = true;
        boolean testStatus = false;
        boolean testCount = false;
        int testUnitCost = 5432;
        String expectedTestResult = TEST_RESULT_STATUS_NO_LONGER_AVALIABLE;
        renderer.setBean((Object)new InventoryBean(1, 0, 0, 5432));
        renderer.setBeanProperty(".");
        String renderedText = renderer.getText();
        Assert.assertEquals((String)"should return warning 1", (Object)TEST_RESULT_STATUS_NO_LONGER_AVALIABLE, (Object)renderedText);
    }

    @Test
    public void testGetTextZeroCountNew() {
        InventoryCountRenderer renderer = new InventoryCountRenderer();
        boolean testProductId = true;
        int testStatus = 2;
        boolean testCount = false;
        int testUnitCost = 5432;
        String expectedTestResult = TEST_RESULT_STATUS_NEW;
        renderer.setBean((Object)new InventoryBean(1, 2, 0, 5432));
        renderer.setBeanProperty(".");
        String renderedText = renderer.getText();
        Assert.assertEquals((String)"should return warning 2", (Object)TEST_RESULT_STATUS_NEW, (Object)renderedText);
    }

    @Test
    public void testGetTextZeroCountSoldOut() {
        InventoryCountRenderer renderer = new InventoryCountRenderer();
        boolean testProductId = true;
        int testStatus = 3;
        boolean testCount = false;
        int testUnitCost = 5432;
        String expectedTestResult = TEST_RESULT_STATUS_OTHER;
        renderer.setBean((Object)new InventoryBean(1, 3, 0, 5432));
        renderer.setBeanProperty(".");
        String renderedText = renderer.getText();
        Assert.assertEquals((String)"should return warning 3", (Object)TEST_RESULT_STATUS_OTHER, (Object)renderedText);
    }
}

