/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples.petstore;

import com.github.bordertech.wcomponents.examples.petstore.ProductImage;
import com.github.bordertech.wcomponents.examples.petstore.model.ProductBean;
import java.awt.Dimension;
import org.junit.Assert;
import org.junit.Test;

public class ProductImage_Test {
    @Test
    public void testConstructorBeanNull() {
        ProductImage image = new ProductImage(null);
        byte[] bytes = image.getBytes();
        Assert.assertNull((String)"should be null - no bean to look for bytes", (Object)bytes);
        Assert.assertNull((String)"should have no description set", (Object)image.getDescription());
        Assert.assertNull((String)"should have no mime type set", (Object)image.getMimeType());
    }

    @Test
    public void testConstructorNameNull() {
        int testProductId = 7;
        String testTitle = "title";
        String testName = null;
        String testDescription = "description";
        ProductBean testProduct = new ProductBean(7, "title", testName, "description");
        ProductImage image = new ProductImage(testProduct);
        byte[] bytes = image.getBytes();
        Assert.assertNull((String)"should be null - no bean/name to look for bytes", (Object)bytes);
        Assert.assertEquals((String)"should have description set to testTitle given", (Object)"title", (Object)image.getDescription());
        Assert.assertNull((String)"should have no mime type set", (Object)image.getMimeType());
    }

    @Test
    public void testConstructorBytesNotFound() {
        int testProductId = 7;
        String testTitle = "title";
        String testName = "dogXXX.gif";
        String testDescription = "description";
        ProductBean testProduct = new ProductBean(7, "title", "dogXXX.gif", "description");
        ProductImage image = new ProductImage(testProduct);
        byte[] bytes = image.getBytes();
        Assert.assertNull((String)"should be null - bean/name set but no file found", (Object)bytes);
        Assert.assertEquals((String)"should have description set to testTitle given", (Object)"title", (Object)image.getDescription());
        Assert.assertNull((String)"should have no mime type set", (Object)image.getMimeType());
    }

    @Test
    public void testConstructorBytesFound() {
        int testProductId = 7;
        String testTitle = "title";
        String testName = "dog.gif";
        String testDescription = "description";
        String expectedMimeType = "image/gif";
        ProductBean testProduct = new ProductBean(7, "title", "dog.gif", "description");
        ProductImage image = new ProductImage(testProduct);
        byte[] bytes = image.getBytes();
        Assert.assertNotNull((String)"should have found file loaded bytes", (Object)bytes);
        Assert.assertTrue((String)"should have bytes found", (bytes.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"should have description set to testTitle given", (Object)"title", (Object)image.getDescription());
        Assert.assertEquals((String)"should have no mime type set", (Object)"image/gif", (Object)image.getMimeType());
    }

    @Test
    public void testSetMimeType() {
        String testMimeType = "text/html";
        ProductImage image = new ProductImage(new ProductBean());
        image.setMimeType("text/html");
        Assert.assertEquals((String)"should return mime type set", (Object)"text/html", (Object)image.getMimeType());
    }

    @Test
    public void testSetSize() {
        Dimension testDim = new Dimension(20, 40);
        ProductImage image = new ProductImage(new ProductBean());
        image.setSize(testDim);
        Assert.assertEquals((String)"should return size set", (Object)testDim, (Object)image.getSize());
    }

    @Test
    public void testSetDescription() {
        String testDescription = "this is a description of itself";
        ProductImage image = new ProductImage(new ProductBean());
        image.setDescription("this is a description of itself");
        Assert.assertEquals((String)"should returnd description set", (Object)"this is a description of itself", (Object)image.getDescription());
    }
}

