/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples.petstore.beanprovider;

import com.github.bordertech.wcomponents.BeanProviderBound;
import com.github.bordertech.wcomponents.WBeanComponent;
import com.github.bordertech.wcomponents.examples.petstore.beanprovider.InventoryBeanProvider;
import com.github.bordertech.wcomponents.examples.petstore.model.InventoryBean;
import com.github.bordertech.wcomponents.examples.petstore.model.PetStoreDao;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class InventoryBeanProvider_Test {
    @Test
    public void testGetInstance() {
        InventoryBeanProvider object = InventoryBeanProvider.getInstance();
        Assert.assertTrue((String)"should return instance of InventoryBeanProvider", (boolean)(object instanceof InventoryBeanProvider));
    }

    @Test
    public void testGetBeanSingleId() {
        boolean testProductId = true;
        InventoryBeanProvider provider = InventoryBeanProvider.getInstance();
        WBeanComponent beanProviderBound = new WBeanComponent();
        beanProviderBound.setBeanId((Object)1);
        Object obj = provider.getBean((BeanProviderBound)beanProviderBound);
        Assert.assertTrue((String)"should return an InventoryBean", (boolean)(obj instanceof InventoryBean));
        Assert.assertEquals((String)"the inventoryBean should have the requested productId", (int)1, (int)((InventoryBean)obj).getProductId());
    }

    @Test
    public void testGetBeanArrayOfIds() {
        int[] testProductIds = new int[]{0, 1, 2};
        InventoryBeanProvider provider = InventoryBeanProvider.getInstance();
        WBeanComponent beanProviderBound = new WBeanComponent();
        beanProviderBound.setBeanId((Object)testProductIds);
        Object obj = provider.getBean((BeanProviderBound)beanProviderBound);
        Assert.assertTrue((String)"should return an InventoryBean[]", (boolean)(obj instanceof InventoryBean[]));
        InventoryBean[] beans = (InventoryBean[])obj;
        Assert.assertEquals((String)"should return an InventoryBean[] of right length", (int)testProductIds.length, (int)beans.length);
        for (int i = 0; i < testProductIds.length; ++i) {
            Assert.assertEquals((String)("product " + i + "  not match expected"), (int)beans[i].getProductId(), (int)testProductIds[i]);
        }
    }

    @Test
    public void testGetBeanArrayOfIdsAllBeans() {
        InventoryBeanProvider provider = InventoryBeanProvider.getInstance();
        WBeanComponent beanProviderBound = new WBeanComponent();
        beanProviderBound.setBeanId((Object)Float.valueOf(42.0f));
        Object obj = provider.getBean((BeanProviderBound)beanProviderBound);
        Assert.assertTrue((String)"should return a List of InventoryBean", (boolean)(obj instanceof List));
        List allBeansReturned = (List)obj;
        List<InventoryBean> allPetStoreBeans = Arrays.asList(PetStoreDao.readInventory());
        Assert.assertEquals((String)"should get all of the store beans", (int)allBeansReturned.size(), (int)allPetStoreBeans.size());
        Assert.assertTrue((String)"provider returned beans contains all beans in the store", (boolean)allBeansReturned.containsAll(allPetStoreBeans));
    }
}

