/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples.petstore.model;

import com.github.bordertech.wcomponents.examples.petstore.model.InventoryBean;
import com.github.bordertech.wcomponents.examples.petstore.model.PetStoreDao;
import com.github.bordertech.wcomponents.examples.petstore.model.ProductBean;
import org.junit.Assert;
import org.junit.Test;

public class PetStoreDao_Test {
    private static final int EXPECTED_INVENTORY_SIZE = 6;
    private static final int GOAT_ID = 3;
    private static final String DUMMY_DESCRIPTION = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. In tristique pellentesque massa, et placerat justo ullamcorper vel. Nunc scelerisque, sem ut hendrerit pharetra, tellus erat dictum felis, at facilisis metus odio ac justo. Curabitur rutrum lacus in nulla iaculis at vestibulum metus facilisis. Aenean id nulla massa. Suspendisse vitae nunc nec urna laoreet elementum. Duis in orci ac leo elementum sagittis ac non massa. Sed vel massa purus, eu facilisis ipsum. Maecenas quis mi non metus scelerisque sagittis quis ac lacus. Fusce faucibus, urna ut viverra vulputate, tellus metus venenatis enim, eget mollis neque libero a turpis. Nullam convallis, lacus vel gravida suscipit, ipsum ante interdum libero, placerat laoreet dui magna et odio.\n\nPhasellus interdum placerat risus ut aliquam. In hac habitasse platea dictumst. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Fusce varius sem sit amet lorem commodo at ornare dui ultricies. Morbi consequat nunc sit amet magna facilisis luctus. Sed sit amet dapibus mi. Donec non quam tortor, sed tincidunt felis. Cras pulvinar ultrices elit in molestie. Morbi sapien nisi, porta in tempor et, dignissim quis nisl. Phasellus facilisis commodo mauris, in tristique velit semper in. Nullam vehicula, urna vel gravida molestie, lectus arcu semper urna, eget feugiat est augue id diam. Nulla dapibus eleifend justo, et malesuada erat accumsan vitae.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteProduct() {
        int testProductId = 3;
        ProductBean oldProduct = PetStoreDao.readProduct((int)3);
        try {
            String newShortTitle = "lemming";
            String newImage = "lemming.gif";
            String newDescription = "has been modified";
            PetStoreDao.writeProduct((ProductBean)new ProductBean(3, "lemming", "lemming.gif", "has been modified"));
            ProductBean newProduct = PetStoreDao.readProduct((int)3);
            Assert.assertEquals((String)"should get productId requested", (long)3L, (long)newProduct.getId());
            Assert.assertEquals((String)"should get title for productdId 3", (Object)"lemming", (Object)newProduct.getShortTitle());
            Assert.assertEquals((String)"should get image for productId 3", (Object)"lemming.gif", (Object)newProduct.getImage());
            Assert.assertEquals((String)"should get description for productId 3", (Object)"has been modified", (Object)newProduct.getDescription());
        }
        finally {
            PetStoreDao.writeProduct((ProductBean)oldProduct);
        }
    }

    @Test
    public void testReadInventory() {
        InventoryBean[] inventory = PetStoreDao.readInventory();
        Assert.assertEquals((String)"should get correct inventory size", (long)6L, (long)inventory.length);
        for (int i = 0; i < 6; ++i) {
            Assert.assertEquals((String)"should get productId equal to index", (long)i, (long)inventory[i].getProductId());
        }
    }

    @Test
    public void testReadInventorySubset() {
        int[] inventoryIds = new int[]{0, 2, 4};
        InventoryBean[] inventory = PetStoreDao.readInventory((int[])inventoryIds);
        Assert.assertEquals((String)"should get correct inventory size", (long)inventoryIds.length, (long)inventory.length);
        for (int i = 0; i < inventoryIds.length; ++i) {
            Assert.assertEquals((String)"should get productId twice the index", (long)(i * 2), (long)inventory[i].getProductId());
        }
    }

    @Test
    public void testReadInventoryItem() {
        boolean expectedStatus = false;
        boolean expectedCount = false;
        int expectedCost = 75000;
        int testProductId = 3;
        InventoryBean item = PetStoreDao.readInventory((int)3);
        Assert.assertEquals((String)"should get expected  productId", (long)3L, (long)item.getProductId());
        Assert.assertEquals((String)"should get status for productId 3", (long)0L, (long)item.getStatus());
        Assert.assertEquals((String)"should get count for productId 3", (long)0L, (long)item.getCount());
        Assert.assertEquals((String)"should get cost for productId 3", (long)75000L, (long)item.getUnitCost());
    }

    @Test
    public void testReadProduct() {
        String expectedTitle = "Goat";
        String expectedImage = "goat.gif";
        String expectedDescription = DUMMY_DESCRIPTION;
        int testProductId = 3;
        ProductBean product = PetStoreDao.readProduct((int)3);
        Assert.assertEquals((String)"should get productId requested", (long)3L, (long)product.getId());
        Assert.assertEquals((String)"should get title for productdId 3", (Object)"Goat", (Object)product.getShortTitle());
        Assert.assertEquals((String)"should get image for productId 3", (Object)"goat.gif", (Object)product.getImage());
        Assert.assertEquals((String)"should get description for productId 3", (Object)DUMMY_DESCRIPTION, (Object)product.getDescription());
    }

    @Test
    public void testReadProductOutOfBounds() {
        try {
            int testProductId = 17;
            PetStoreDao.readProduct((int)17);
            Assert.fail((String)"should throw ArrayOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Assert.assertNotNull((String)"ArrayOutOfBoundsException message", (Object)e.getMessage());
        }
    }

    @Test
    public void testWriteInventory() {
        int testProductId = 3;
        int newStatus = 2;
        int newCount = 99;
        int newUnitCost = 1995;
        PetStoreDao.writeInventory((InventoryBean)new InventoryBean(3, 2, 99, 1995));
        InventoryBean item = PetStoreDao.readInventory((int)3);
        Assert.assertEquals((String)"should get expected  productId", (long)3L, (long)item.getProductId());
        Assert.assertEquals((String)"should get new status for productId 3", (long)2L, (long)item.getStatus());
        Assert.assertEquals((String)"should get new count for productId 3", (long)99L, (long)item.getCount());
        Assert.assertEquals((String)"should get new cost for productId 3", (long)1995L, (long)item.getUnitCost());
    }
}

