/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples.petstore.model;

import com.github.bordertech.wcomponents.examples.petstore.model.CartBean;
import com.github.bordertech.wcomponents.examples.petstore.model.ConfirmOrderBean;
import com.github.bordertech.wcomponents.examples.petstore.model.PlaceOrderService;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class PlaceOrderService_Test {
    private static final int FIXED_INITIAL_ORDER_SEQUENCE_NUMBER = 12345;
    private static int orderSequenceNumber = -1;

    private static PlaceOrderService.OrderStatus placeOrder(List<CartBean> cart, ConfirmOrderBean clientDetails) {
        PlaceOrderService service = PlaceOrderService.getInstance();
        PlaceOrderService.OrderStatus result = service.placeOrder(cart, clientDetails);
        if (result.getStatus() == 1) {
            orderSequenceNumber = orderSequenceNumber < 0 ? 12345 : ++orderSequenceNumber;
        }
        return result;
    }

    @Test
    public void testGetInstance() {
        PlaceOrderService service = PlaceOrderService.getInstance();
        Assert.assertNotNull((String)"should return non null service", (Object)service);
    }

    @Test
    public void testPlaceOrder() {
        CartBean cartBean1 = new CartBean(0, 1);
        CartBean cartBean2 = new CartBean(1, 1);
        ArrayList<CartBean> cart = new ArrayList<CartBean>();
        cart.add(cartBean1);
        cart.add(cartBean2);
        ConfirmOrderBean clientDetails = new ConfirmOrderBean();
        clientDetails.setFirstName("Fred");
        clientDetails.setLastName("Flinstone");
        PlaceOrderService.OrderStatus result = PlaceOrderService_Test.placeOrder(cart, clientDetails);
        Assert.assertEquals((String)"should be successful", (long)1L, (long)result.getStatus());
        Assert.assertEquals((String)"should get correct sequence number", (Object)orderSequenceNumber, (Object)result.getDetails());
        result = PlaceOrderService_Test.placeOrder(cart, clientDetails);
        Assert.assertEquals((String)"should be successful", (long)1L, (long)result.getStatus());
        Assert.assertEquals((String)"should get correct sequence number", (Object)orderSequenceNumber, (Object)result.getDetails());
    }

    @Test
    public void testPlaceOrderUnsuccessfully() {
        CartBean cartBean1 = new CartBean(0, 500);
        CartBean cartBean2 = new CartBean(1, 1);
        ArrayList<CartBean> cart = new ArrayList<CartBean>();
        cart.add(cartBean1);
        cart.add(cartBean2);
        ConfirmOrderBean clientDetails = new ConfirmOrderBean();
        clientDetails.setFirstName("Fred");
        clientDetails.setLastName("Flinstone");
        PlaceOrderService.OrderStatus result = PlaceOrderService_Test.placeOrder(cart, clientDetails);
        Assert.assertEquals((String)"should get insufficient stock", (long)2L, (long)result.getStatus());
        Assert.assertEquals((String)"should get cartBean1 details", (Object)cartBean1, (Object)result.getDetails());
    }

    @Test
    public void testPlaceOrderTooMany() {
        ConfirmOrderBean clientDetails = new ConfirmOrderBean();
        clientDetails.setFirstName("Fred");
        clientDetails.setLastName("Flinstone");
        CartBean cartBean1 = new CartBean(2, 30);
        CartBean cartBean2 = new CartBean(1, 1);
        ArrayList<CartBean> cart = new ArrayList<CartBean>();
        cart.add(cartBean1);
        cart.add(cartBean2);
        PlaceOrderService.OrderStatus result = PlaceOrderService_Test.placeOrder(cart, clientDetails);
        Assert.assertEquals((String)"should be successful", (long)1L, (long)result.getStatus());
        Assert.assertEquals((String)"should get correct sequence number", (Object)orderSequenceNumber, (Object)result.getDetails());
        CartBean cartBean3 = new CartBean(2, 21);
        ArrayList<CartBean> cart2 = new ArrayList<CartBean>();
        cart2.add(cartBean3);
        result = PlaceOrderService_Test.placeOrder(cart2, clientDetails);
        Assert.assertEquals((String)"should get Insuffient stock", (long)2L, (long)result.getStatus());
        Assert.assertEquals((String)"should get cartbean3 details", (Object)cartBean3, (Object)result.getDetails());
    }

    @Test
    public void testOrderStatusConstructor() {
        int status = 27;
        String details = new String("details of order");
        String userMessage = "user message";
        PlaceOrderService.OrderStatus orderStatus = new PlaceOrderService.OrderStatus(27, (Object)details, "user message");
        Assert.assertEquals((String)"status should be value set", (long)27L, (long)orderStatus.getStatus());
        Assert.assertEquals((String)"details should be object set", (Object)details, (Object)orderStatus.getDetails());
        Assert.assertEquals((String)"userMessage should be value set", (Object)"user message", (Object)orderStatus.getUserMessage());
        orderStatus = new PlaceOrderService.OrderStatus(0, (Object)details, "user message");
        Assert.assertEquals((String)"status should be static value set", (long)0L, (long)orderStatus.getStatus());
        orderStatus = new PlaceOrderService.OrderStatus(1, (Object)details, "user message");
        Assert.assertEquals((String)"status should be static value set", (long)1L, (long)orderStatus.getStatus());
        orderStatus = new PlaceOrderService.OrderStatus(2, (Object)details, "user message");
        Assert.assertEquals((String)"status should be static value set", (long)2L, (long)orderStatus.getStatus());
    }
}

