/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples;

import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.test.selenium.ByWComponent;
import com.github.bordertech.wcomponents.test.selenium.ByWComponentPath;
import com.github.bordertech.wcomponents.test.selenium.WComponentSeleniumTestCase;
import com.github.bordertech.wcomponents.test.selenium.driver.WebDriverType;
import com.github.bordertech.wcomponents.test.selenium.server.ServerCache;
import com.github.bordertech.wcomponents.util.ConfigurationProperties;
import java.util.UUID;
import org.junit.After;
import org.junit.Before;

public abstract class WComponentExamplesTestCase
extends WComponentSeleniumTestCase {
    private static boolean USE_PARALLEL_METHODS = ConfigurationProperties.getTestSeleniumParallelMethods();
    private final WComponent ui;

    public WComponentExamplesTestCase(WComponent testUI) {
        this.ui = ServerCache.setUI((String)((Object)((Object)this)).getClass().getName(), (WComponent)testUI);
        super.setUrl(ServerCache.getUrl());
    }

    public ByWComponentPath byWComponentPath(String path) {
        return new ByWComponentPath(this.ui, path);
    }

    public ByWComponentPath byWComponentPath(String path, boolean visibleOnly) {
        return new ByWComponentPath(this.ui, path, visibleOnly);
    }

    public ByWComponentPath byWComponentPath(String path, Object value) {
        return new ByWComponentPath(this.ui, null, path, value);
    }

    public ByWComponentPath byWComponentPath(String path, Object value, boolean visibleOnly) {
        return new ByWComponentPath(this.ui, null, path, value, visibleOnly);
    }

    public ByWComponent byWComponent(WComponent component) {
        return new ByWComponent(component);
    }

    public ByWComponent byWComponent(WComponent component, Object value) {
        return new ByWComponent(component, null, value);
    }

    public WComponent getUi() {
        return this.ui;
    }

    @Before
    public void setupDriver() {
        if (USE_PARALLEL_METHODS) {
            WebDriverType type = this.getDriverType();
            String driverId = UUID.randomUUID().toString();
            this.setDriver(type, driverId);
        }
    }

    @After
    public void tearDownDriver() {
        if (USE_PARALLEL_METHODS) {
            this.releaseDriver();
        }
    }
}

