/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples;

import com.github.bordertech.wcomponents.UIContext;
import com.github.bordertech.wcomponents.UIContextHolder;
import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.WDropdown;
import com.github.bordertech.wcomponents.examples.SeleniumTests;
import com.github.bordertech.wcomponents.examples.WComponentExamplesTestCase;
import com.github.bordertech.wcomponents.examples.WDropdownOptionsExample;
import com.github.bordertech.wcomponents.test.selenium.ByWComponent;
import com.github.bordertech.wcomponents.test.selenium.MultiBrowserRunner;
import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriver;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWCheckBoxWebElement;
import com.github.bordertech.wcomponents.util.TreeUtil;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;

@Category(value={SeleniumTests.class})
@RunWith(value=MultiBrowserRunner.class)
public class WDropdownOptionsExample_Test
extends WComponentExamplesTestCase {
    public WDropdownOptionsExample_Test() {
        super((WComponent)new WDropdownOptionsExample());
    }

    private void configureDropDown(SeleniumWComponentsWebDriver driver, WDropdown.DropdownType type, int actionNumber) {
        SeleniumWCheckBoxWebElement actionOnChange = driver.findWCheckBox((By)this.byWComponentPath("WCheckBox[1]"));
        while (!actionOnChange.isSelected()) {
            actionOnChange.click();
        }
        SeleniumWCheckBoxWebElement action = driver.findWCheckBox((By)this.byWComponentPath("WCheckBox[" + actionNumber + "]"));
        while (!action.isSelected()) {
            action.click();
        }
        driver.findElement((ByWComponent)this.byWComponentPath("WRadioButtonSelect[0]", type)).click();
        SeleniumWCheckBoxWebElement includeNullOption = driver.findWCheckBox((By)this.byWComponentPath("WCheckBox[0]"));
        while (!includeNullOption.isSelected()) {
            includeNullOption.click();
        }
        driver.findElement((ByWComponent)this.byWComponentPath("WDropdownOptionsExample/WFieldSet/WButton")).click();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExampleSubmitOnChange() {
        WDropdownOptionsExample example = (WDropdownOptionsExample)this.getUi();
        SeleniumWComponentsWebDriver driver = this.getDriver();
        WDropdown.DropdownType type = WDropdown.DropdownType.NATIVE;
        this.configureDropDown(driver, type, 4);
        UIContext uic = this.getUserContextForSession();
        UIContextHolder.pushContext((UIContext)uic);
        try {
            WDropdown dropdown = (WDropdown)TreeUtil.findWComponent((WComponent)example, (String[])new String[]{"WDropdown"}).getComponent();
            List options = dropdown.getOptions();
            for (Object option : options) {
                driver.findElement(this.byWComponent((WComponent)dropdown, option)).click();
                Assert.assertEquals((String)"Incorrect option selected", option, (Object)dropdown.getSelected());
                Assert.assertEquals((String)"Incorrect text field text", option, (Object)driver.findElement((ByWComponent)this.byWComponentPath("WDropdownOptionsExample/WPanel[1]")).getText());
            }
        }
        finally {
            UIContextHolder.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExampleAjax() {
        WDropdownOptionsExample example = (WDropdownOptionsExample)this.getUi();
        SeleniumWComponentsWebDriver driver = this.getDriver();
        WDropdown.DropdownType type = WDropdown.DropdownType.NATIVE;
        this.configureDropDown(driver, type, 2);
        UIContext uic = this.getUserContextForSession();
        UIContextHolder.pushContext((UIContext)uic);
        try {
            WDropdown dropdown = (WDropdown)TreeUtil.findWComponent((WComponent)example, (String[])new String[]{"WDropdown"}).getComponent();
            List options = dropdown.getOptions();
            for (Object option : options) {
                driver.findElement(this.byWComponent((WComponent)dropdown, option)).click();
                Assert.assertEquals((String)"Incorrect option selected", option, (Object)dropdown.getSelected());
                Assert.assertEquals((String)"Incorrect text field text", option, (Object)driver.findElement((ByWComponent)this.byWComponentPath("WDropdownOptionsExample/WPanel[1]")).getText());
            }
        }
        finally {
            UIContextHolder.popContext();
        }
    }
}

