/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples.theme;

import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.examples.SeleniumTests;
import com.github.bordertech.wcomponents.examples.WComponentExamplesTestCase;
import com.github.bordertech.wcomponents.examples.theme.WLabelExample;
import com.github.bordertech.wcomponents.test.selenium.ByLabel;
import com.github.bordertech.wcomponents.test.selenium.ByWComponent;
import com.github.bordertech.wcomponents.test.selenium.MultiBrowserRunner;
import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriver;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWLabelWebElement;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;

@Category(value={SeleniumTests.class})
@RunWith(value=MultiBrowserRunner.class)
public class WLabelExample_Test
extends WComponentExamplesTestCase {
    public WLabelExample_Test() {
        super((WComponent)new WLabelExample());
    }

    @Test
    public void testLabelCreated() {
        Assert.assertNotNull((Object)this.getDriver().findWLabel((By)this.byWComponentPath("WLabel[0]")));
    }

    @Test
    public void testGetByText() {
        Assert.assertNotNull((Object)this.getDriver().findWLabelWithPartialText("Normal input component"));
    }

    @Test
    public void testGetByTextComplexComponent() {
        Assert.assertNotNull((Object)this.getDriver().findWLabelWithPartialText("Select one or more options"));
    }

    @Test
    public void testGetByTextWFieldSet() {
        Assert.assertNotNull((Object)this.getDriver().findWLabelWithPartialText("Enter the dates of entry and exit"));
    }

    @Test
    public void testIsHidden() {
        SeleniumWLabelWebElement label = this.getDriver().findWLabel((By)this.byWComponentPath("WLabel[1]"));
        Assert.assertTrue((boolean)label.isHidden());
    }

    @Test
    public void testGetByTextHidden() {
        SeleniumWLabelWebElement label = this.getDriver().findWLabel((By)this.byWComponentPath("WLabel[1]"));
        Assert.assertTrue((boolean)label.isHidden());
        String text = label.getText();
        Assert.assertNotNull((Object)this.getDriver().findWLabelWithPartialText(text));
    }

    @Test
    public void testIsReadOnly() {
        SeleniumWLabelWebElement label = this.getDriver().findWLabel((By)this.byWComponentPath("WLabel[2]"));
        Assert.assertTrue((boolean)label.isReadOnly());
    }

    @Test
    public void testGetComponentSimple() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWLabelWebElement label = driver.findWLabel((By)this.byWComponentPath("WLabel[0]"));
        SeleniumWComponentWebElement expected = driver.findElement((ByWComponent)this.byWComponentPath("WTextField[0]"));
        Assert.assertEquals((Object)expected.getAttribute("id"), (Object)label.getLabelledComponent().getAttribute("id"));
    }

    @Test
    public void testGetComponentComplex() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWLabelWebElement label = driver.findWLabel((By)this.byWComponentPath("WLabel[7]"));
        SeleniumWComponentWebElement expected = driver.findElement((ByWComponent)this.byWComponentPath("WCheckBoxSelect[1]"));
        Assert.assertEquals((Object)expected.getAttribute("id"), (Object)label.getLabelledComponent().getAttribute("id"));
    }

    @Test
    public void testGetComponentReadOnly() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWLabelWebElement label = driver.findWLabel((By)this.byWComponentPath("WLabel[2]"));
        Assert.assertTrue((boolean)label.isReadOnly());
        SeleniumWComponentWebElement expected = driver.findElement((ByWComponent)this.byWComponentPath("WTextField[2]"));
        Assert.assertEquals((Object)expected.getAttribute("id"), (Object)label.getLabelledComponent().getAttribute("id"));
    }

    @Test
    public void testGetByLabelSimple() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        String labelText = "Normal input component";
        SeleniumWComponentWebElement expected = driver.findElement((ByWComponent)this.byWComponentPath("WTextField[0]"));
        SeleniumWComponentWebElement actual = driver.findElement((By)new ByLabel(labelText, false));
        Assert.assertEquals((Object)expected.getAttribute("id"), (Object)actual.getAttribute("id"));
    }

    @Test
    public void testGetByLabelSimplePartial() {
        String labelText = "Normal input";
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWComponentWebElement expected = driver.findElement((ByWComponent)this.byWComponentPath("WTextField[0]"));
        SeleniumWComponentWebElement actual = driver.findElement((By)new ByLabel(labelText, true));
        Assert.assertEquals((Object)expected.getAttribute("id"), (Object)actual.getAttribute("id"));
    }

    @Test
    public void testGetByLabelComplex() {
        String labelText = "Select one or more options";
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWComponentWebElement expected = driver.findElement((ByWComponent)this.byWComponentPath("WCheckBoxSelect[1]"));
        SeleniumWComponentWebElement actual = driver.findElement((By)new ByLabel(labelText, false));
        Assert.assertEquals((Object)expected.getAttribute("id"), (Object)actual.getAttribute("id"));
    }

    @Test
    public void testGetByLabelComplexPartial() {
        String labelText = "one or more";
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWComponentWebElement expected = driver.findElement((ByWComponent)this.byWComponentPath("WCheckBoxSelect[1]"));
        SeleniumWComponentWebElement actual = driver.findElement((By)new ByLabel(labelText, true));
        Assert.assertEquals((Object)expected.getAttribute("id"), (Object)actual.getAttribute("id"));
    }

    @Test
    public void testGetByLabelReadOnly() {
        String labelText = "A hidden label for a read only field";
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWComponentWebElement expected = driver.findElement((ByWComponent)this.byWComponentPath("WTextField[2]"));
        SeleniumWComponentWebElement actual = driver.findElement((By)new ByLabel(labelText, false));
        Assert.assertEquals((Object)expected.getAttribute("id"), (Object)actual.getAttribute("id"));
    }

    @Test
    public void testGetByLabelReadOnlyPartial() {
        String labelText = "for a read only";
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWComponentWebElement expected = driver.findElement((ByWComponent)this.byWComponentPath("WTextField[2]"));
        SeleniumWComponentWebElement actual = driver.findElement((By)new ByLabel(labelText, true));
        Assert.assertEquals((Object)expected.getAttribute("id"), (Object)actual.getAttribute("id"));
    }
}

