/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples;

import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.WContainer;
import com.github.bordertech.wcomponents.WField;
import com.github.bordertech.wcomponents.WFieldLayout;
import com.github.bordertech.wcomponents.examples.SeleniumTests;
import com.github.bordertech.wcomponents.examples.WComponentExamplesTestCase;
import com.github.bordertech.wcomponents.examples.theme.WCheckBoxExample;
import com.github.bordertech.wcomponents.test.selenium.ByLabel;
import com.github.bordertech.wcomponents.test.selenium.MultiBrowserRunner;
import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriver;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@Category(value={SeleniumTests.class})
@RunWith(value=MultiBrowserRunner.class)
public class WCheckBoxExample_Test
extends WComponentExamplesTestCase {
    public WCheckBoxExample_Test() {
        super((WComponent)new WCheckBoxExample());
    }

    @Test
    public void testFindByLabelId() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        WContainer container = (WContainer)this.getUi();
        WFieldLayout layout = (WFieldLayout)container.getChildAt(0);
        WField field = (WField)layout.getChildAt(0);
        String labelId = field.getLabel().getId();
        String componentId = field.getField().getId();
        WebElement checkBox = driver.findElement((By)new ByLabel(labelId));
        Assert.assertNotNull((String)"Unable to find checkbox by labelId", (Object)checkBox);
        Assert.assertEquals((String)"Checkbox element ID does not match expected", (Object)componentId, (Object)checkBox.getAttribute("id"));
    }

    @Test
    public void testFindByLabelTextExact() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        WContainer container = (WContainer)this.getUi();
        WFieldLayout layout = (WFieldLayout)container.getChildAt(0);
        WField field = (WField)layout.getChildAt(0);
        String labelText = field.getLabel().getText();
        String componentId = field.getField().getId();
        WebElement checkBox = driver.findElement((By)new ByLabel(labelText, false));
        Assert.assertNotNull((String)"Unable to find checkbox by label text", (Object)checkBox);
        Assert.assertEquals((String)"Checkbox element ID does not match expected", (Object)componentId, (Object)checkBox.getAttribute("id"));
    }

    @Test
    public void testFindByLabelTextPartial() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        List checkBoxes = driver.findElements((By)new ByLabel("check box", true));
        Assert.assertNotNull((String)"Unable to find checkboxes by label text partial match", (Object)checkBoxes);
        Assert.assertEquals((String)"Incorrect number of check boxes found by partial text match", (long)5L, (long)checkBoxes.size());
    }
}

