/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples;

import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.examples.SeleniumTests;
import com.github.bordertech.wcomponents.examples.WComponentExamplesTestCase;
import com.github.bordertech.wcomponents.examples.WMultiDropdownTestingExample;
import com.github.bordertech.wcomponents.test.selenium.ByLabel;
import com.github.bordertech.wcomponents.test.selenium.ByWComponent;
import com.github.bordertech.wcomponents.test.selenium.MultiBrowserRunner;
import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriver;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWMultiDropdownWebElement;
import com.github.bordertech.wcomponents.util.SystemException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

@Category(value={SeleniumTests.class})
@RunWith(value=MultiBrowserRunner.class)
public class WMultiDropdownTestingExample_Test
extends WComponentExamplesTestCase {
    private SeleniumWMultiDropdownWebElement getByLabel(String text) {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        return driver.findWMultiDropdown((By)new ByLabel(text, false));
    }

    public WMultiDropdownTestingExample_Test() {
        super((WComponent)new WMultiDropdownTestingExample());
    }

    @Test
    public void testFind() {
        Assert.assertNotNull((Object)this.getByLabel("No selection"));
        Assert.assertNotNull((Object)this.getByLabel("Read only no selection"));
        Assert.assertNotNull((Object)this.getByLabel("Disabled"));
    }

    private void getOptionsHelper(SeleniumWMultiDropdownWebElement component) {
        List options = component.getOptions();
        Assert.assertEquals((long)WMultiDropdownTestingExample.DATA_LIST.size(), (long)options.size());
        for (WebElement option : options) {
            Assert.assertTrue((boolean)WMultiDropdownTestingExample.DATA_LIST.contains(option.getText()));
        }
    }

    private void getOptionsHelper(SeleniumWMultiDropdownWebElement component, List expected) {
        List options = component.getOptions();
        Assert.assertEquals((long)expected.size(), (long)options.size());
        for (WebElement option : options) {
            Assert.assertTrue((boolean)expected.contains(option.getText()));
        }
    }

    @Test
    public void testGetOptions() {
        this.getOptionsHelper(this.getByLabel("Some selected by default"));
        this.getOptionsHelper(this.getByLabel("No selection"));
        this.getOptionsHelper(this.getByLabel("All selected by default"));
        this.getOptionsHelper(this.getByLabel("Read only some selected by default"), WMultiDropdownTestingExample.DATA_SOME_SELECTED);
        this.getOptionsHelper(this.getByLabel("Read only one selected by default"), WMultiDropdownTestingExample.DATA_ONE_SELECTED);
        this.getOptionsHelper(this.getByLabel("Read only all selected by default"), WMultiDropdownTestingExample.DATA_LIST);
        this.getOptionsHelper(this.getByLabel("Read only no selection"), Arrays.asList((String)WMultiDropdownTestingExample.DATA_LIST.get(0)));
    }

    @Test
    public void testEnabled() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Some selected by default");
        Assert.assertTrue((boolean)component.isEnabled());
        component = this.getByLabel("Disabled");
        Assert.assertFalse((boolean)component.isEnabled());
        component = this.getByLabel("Read only some selected by default");
        Assert.assertFalse((boolean)component.isEnabled());
    }

    @Test
    public void testMandatory() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Mandatory");
        Assert.assertTrue((boolean)component.isMandatory());
        component = this.getByLabel("Some selected by default");
        Assert.assertFalse((boolean)component.isMandatory());
    }

    @Test
    public void testDefaultSelection() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("No selection");
        List actual = component.getSelected();
        Assert.assertEquals((long)1L, (long)actual.size());
        String expectedValue = (String)WMultiDropdownTestingExample.DATA_LIST.get(0);
        String selectedValue = ((WebElement)actual.get(0)).getText();
        Assert.assertTrue((boolean)expectedValue.equalsIgnoreCase(selectedValue));
        component = this.getByLabel("Read only no selection");
        actual = component.getSelected();
        Assert.assertEquals((long)1L, (long)actual.size());
        expectedValue = (String)WMultiDropdownTestingExample.DATA_LIST.get(0);
        selectedValue = ((WebElement)actual.get(0)).getText();
        Assert.assertTrue((boolean)expectedValue.equalsIgnoreCase(selectedValue));
        component = this.getByLabel("One selected by default");
        actual = component.getSelected();
        Assert.assertEquals((long)1L, (long)actual.size());
        expectedValue = (String)WMultiDropdownTestingExample.DATA_ONE_SELECTED.get(0);
        selectedValue = ((WebElement)actual.get(0)).getText();
        Assert.assertTrue((boolean)expectedValue.equalsIgnoreCase(selectedValue));
        component = this.getByLabel("Read only one selected by default");
        actual = component.getSelected();
        Assert.assertEquals((long)1L, (long)actual.size());
        expectedValue = (String)WMultiDropdownTestingExample.DATA_ONE_SELECTED.get(0);
        selectedValue = ((WebElement)actual.get(0)).getText();
        Assert.assertTrue((boolean)expectedValue.equalsIgnoreCase(selectedValue));
        component = this.getByLabel("Some selected by default");
        actual = component.getSelected();
        List expectedData = WMultiDropdownTestingExample.DATA_SOME_SELECTED;
        Assert.assertEquals((long)expectedData.size(), (long)actual.size());
        for (WebElement option : actual) {
            selectedValue = option.getText();
            Assert.assertTrue((boolean)expectedData.contains(selectedValue));
        }
        component = this.getByLabel("Read only some selected by default");
        actual = component.getSelected();
        expectedData = WMultiDropdownTestingExample.DATA_SOME_SELECTED;
        Assert.assertEquals((long)expectedData.size(), (long)actual.size());
        for (WebElement option : actual) {
            selectedValue = option.getText();
            Assert.assertTrue((boolean)expectedData.contains(selectedValue));
        }
        component = this.getByLabel("Disabled");
        Assert.assertTrue((boolean)component.getSelected().isEmpty());
        Assert.assertEquals((long)WMultiDropdownTestingExample.DATA_SOME_SELECTED.size(), (long)component.getDropdowns().size());
    }

    private void getDropdownsHelper(SeleniumWMultiDropdownWebElement component, List expected) {
        List dropdowns = component.getDropdowns();
        Assert.assertEquals((long)expected.size(), (long)dropdowns.size());
        for (WebElement dropdown : dropdowns) {
            Select se = new Select(dropdown);
            Assert.assertTrue((boolean)expected.contains(se.getFirstSelectedOption().getText()));
        }
    }

    @Test
    public void testGetDropdowns() {
        this.getDropdownsHelper(this.getByLabel("Some selected by default"), WMultiDropdownTestingExample.DATA_SOME_SELECTED);
        this.getDropdownsHelper(this.getByLabel("One selected by default"), WMultiDropdownTestingExample.DATA_ONE_SELECTED);
        this.getDropdownsHelper(this.getByLabel("All selected by default"), WMultiDropdownTestingExample.DATA_LIST);
        this.getDropdownsHelper(this.getByLabel("No selection"), Arrays.asList((String)WMultiDropdownTestingExample.DATA_LIST.get(0)));
        Assert.assertEquals((long)WMultiDropdownTestingExample.DATA_SOME_SELECTED.size(), (long)this.getByLabel("Disabled").getDropdowns().size());
    }

    @Test(expected=SystemException.class)
    public void testGetDropdownsReadOnly() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Read only one selected by default");
        component.getDropdowns();
    }

    @Test
    public void testGetAddButton() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("No selection");
        WebElement button = component.getAddButton();
        Assert.assertNotNull((Object)button);
        component = this.getByLabel("Disabled");
        button = component.getAddButton();
        Assert.assertNotNull((Object)button);
        Assert.assertFalse((boolean)button.isEnabled());
    }

    @Test(expected=SystemException.class)
    public void testGetAddButtonReadOnly() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Read only one selected by default");
        component.getAddButton();
    }

    @Test
    public void testGetDropdownByIdx() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Some selected by default");
        for (int i = 0; i < WMultiDropdownTestingExample.DATA_SOME_SELECTED.size(); ++i) {
            Assert.assertNotNull((Object)component.getDropdown(i));
        }
    }

    @Test(expected=SystemException.class)
    public void testGetDropdownByIdxReadOnly() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Read only some selected by default");
        component.getDropdown(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDropdownByLowIdx() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Some selected by default");
        component.getDropdown(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDropdownByHighIdx() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Some selected by default");
        component.getDropdown(WMultiDropdownTestingExample.DATA_SOME_SELECTED.size());
    }

    @Test
    public void testGetDropdownByText() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Some selected by default");
        for (String text : WMultiDropdownTestingExample.DATA_SOME_SELECTED) {
            Assert.assertNotNull((Object)component.getDropdown(text));
        }
    }

    @Test(expected=SystemException.class)
    public void testGetDropdownByTextRO() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Read only some selected by default");
        component.getDropdown((String)WMultiDropdownTestingExample.DATA_SOME_SELECTED.get(0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDropdownByTextNull() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Some selected by default");
        component.getDropdown(null);
    }

    @Test(expected=SystemException.class)
    public void testGetDropdownByTextNonsense() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Some selected by default");
        String notInThisWorld = StringUtils.join((Iterable)WMultiDropdownTestingExample.DATA_SOME_SELECTED, (String)" ");
        component.getDropdown(notInThisWorld);
    }

    @Test
    public void testGetFirstDropdown() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Some selected by default");
        Assert.assertNotNull((Object)component.getFirstDropdown());
    }

    @Test(expected=SystemException.class)
    public void testGetFirstDropdownRO() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Read only some selected by default");
        component.getFirstDropdown();
    }

    @Test
    public void testGetRemoveButton() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("All selected by default");
        WebElement dropdown = component.getDropdown(1);
        Assert.assertNotNull((Object)component.getRemoveButton(dropdown));
    }

    @Test(expected=SystemException.class)
    public void testGetRemoveButtonRO() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Read only all selected by default");
        component.getRemoveButton(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetRemoveButtonNull() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("All selected by default");
        component.getRemoveButton(null);
    }

    @Test(expected=SystemException.class)
    public void testGetRemoveButtonFirstDropdown() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("All selected by default");
        component.getRemoveButton(component.getFirstDropdown());
    }

    private void isSelectedHelper(SeleniumWMultiDropdownWebElement component, List expected) {
        for (String value : WMultiDropdownTestingExample.DATA_LIST) {
            boolean actual = component.isSelected(value);
            if (expected.contains(value)) {
                Assert.assertTrue((boolean)actual);
                continue;
            }
            Assert.assertFalse((boolean)actual);
        }
    }

    @Test
    public void testIsSelected() {
        this.isSelectedHelper(this.getByLabel("Some selected by default"), WMultiDropdownTestingExample.DATA_SOME_SELECTED);
        this.isSelectedHelper(this.getByLabel("Read only some selected by default"), WMultiDropdownTestingExample.DATA_SOME_SELECTED);
    }

    @Test
    public void testIsSelectedByValue() {
    }

    private void reset() {
        SeleniumWComponentWebElement resetButton = this.getDriver().findElement((ByWComponent)this.byWComponentPath("WButton[0]"), false);
        resetButton.click();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelect() {
        try {
            SeleniumWMultiDropdownWebElement component = this.getByLabel("No selection");
            List startSelection = component.getSelected();
            String text = (String)WMultiDropdownTestingExample.DATA_LIST.get(1);
            component.select(text);
            List endSelection = component.getSelected();
            Assert.assertEquals((long)(startSelection.size() + 1), (long)endSelection.size());
            Assert.assertTrue((boolean)text.equalsIgnoreCase(((WebElement)endSelection.get(0)).getText()));
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeselect() {
        try {
            SeleniumWMultiDropdownWebElement component = this.getByLabel("All selected by default");
            List startSelection = component.getSelected();
            String text = (String)WMultiDropdownTestingExample.DATA_LIST.get(1);
            component.deselect(text);
            List endSelection = component.getSelected();
            Assert.assertEquals((long)(startSelection.size() - 1), (long)endSelection.size());
            for (WebElement option : endSelection) {
                if (!text.equalsIgnoreCase(option.getText())) continue;
                Assert.assertFalse((String)"Should not have this in the selection", (boolean)true);
            }
        }
        finally {
            this.reset();
        }
    }

    @Test(expected=SystemException.class)
    public void testDeselectReadOnly() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Read only all selected by default");
        String text = (String)WMultiDropdownTestingExample.DATA_LIST.get(1);
        component.deselect(text);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeselectNull() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("All selected by default");
        component.deselect(null);
    }

    @Test(expected=SystemException.class)
    public void testDeselectNotSelected() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Some selected by default");
        component.deselect(StringUtils.join((Iterable)WMultiDropdownTestingExample.DATA_SOME_SELECTED, (String)" "));
    }

    @Test(expected=SystemException.class)
    public void testDeselectFirstOption() {
        SeleniumWMultiDropdownWebElement component = this.getByLabel("Some selected by default");
        component.deselect((String)WMultiDropdownTestingExample.DATA_SOME_SELECTED.get(0));
    }

    @Test
    public void testDeselectAll() {
        try {
            SeleniumWMultiDropdownWebElement component = this.getByLabel("All selected by default");
            component.deselectAll();
            List endSelection = component.getSelected();
            Assert.assertEquals((long)1L, (long)endSelection.size());
            Assert.assertTrue((boolean)((String)WMultiDropdownTestingExample.DATA_LIST.get(0)).equalsIgnoreCase(((WebElement)endSelection.get(0)).getText()));
        }
        finally {
            this.reset();
        }
    }
}

