/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples;

import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.examples.SeleniumTests;
import com.github.bordertech.wcomponents.examples.WComponentExamplesTestCase;
import com.github.bordertech.wcomponents.examples.WMultiSelectPairTestingExample;
import com.github.bordertech.wcomponents.test.selenium.ByLabel;
import com.github.bordertech.wcomponents.test.selenium.MultiBrowserRunner;
import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriver;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWMultiSelectPairWebElement;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@Category(value={SeleniumTests.class})
@RunWith(value=MultiBrowserRunner.class)
public class WMultiSelectPairTestingExample_Test
extends WComponentExamplesTestCase {
    private static final String[] SHAPES = new String[]{"Circle", "Oval", "Rectangle", "Square", "Triangle"};

    private SeleniumWMultiSelectPairWebElement getByLabel(String text) {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        return driver.findWMultiSelectPair((By)new ByLabel(text, false));
    }

    private SeleniumWMultiSelectPairWebElement getExampleNoSelection() {
        return this.getByLabel("Simple");
    }

    private SeleniumWMultiSelectPairWebElement getExampleWithSelection() {
        return this.getByLabel("All selected");
    }

    private SeleniumWMultiSelectPairWebElement getExampleDisabledWithSelection() {
        return this.getByLabel("Disabled with apparent selection");
    }

    private SeleniumWMultiSelectPairWebElement getExampleRadOnlyNoSelection() {
        return this.getByLabel("Read-only no selection");
    }

    private SeleniumWMultiSelectPairWebElement getExampleReadOnlyWithSelection() {
        return this.getByLabel("Read-only with selection");
    }

    private SeleniumWMultiSelectPairWebElement getExampleWithSomeSelection() {
        return this.getByLabel("Some selected");
    }

    public WMultiSelectPairTestingExample_Test() {
        super((WComponent)new WMultiSelectPairTestingExample());
    }

    @Test
    public void testFind() {
        Assert.assertNotNull((Object)this.getExampleNoSelection());
        Assert.assertNotNull((Object)this.getExampleDisabledWithSelection());
        Assert.assertNotNull((Object)this.getExampleReadOnlyWithSelection());
    }

    @Test
    public void testComponentProperties() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWMultiSelectPairWebElement interactive = this.getExampleNoSelection();
        SeleniumWMultiSelectPairWebElement disabled = this.getExampleDisabledWithSelection();
        SeleniumWMultiSelectPairWebElement readOnly = this.getExampleReadOnlyWithSelection();
        Assert.assertTrue((boolean)interactive.isEnabled());
        Assert.assertFalse((boolean)disabled.isEnabled());
        Assert.assertFalse((boolean)readOnly.isEnabled());
        Assert.assertFalse((boolean)interactive.isReadOnly());
        Assert.assertFalse((boolean)disabled.isReadOnly());
        Assert.assertTrue((boolean)readOnly.isReadOnly());
        Assert.assertFalse((boolean)interactive.isMandatory());
        Assert.assertFalse((boolean)disabled.isMandatory());
        Assert.assertFalse((boolean)readOnly.isMandatory());
        SeleniumWMultiSelectPairWebElement msp = driver.findWMultiSelectPair((By)new ByLabel("Mandatory", false));
        Assert.assertTrue((boolean)msp.isMandatory());
        Assert.assertTrue((boolean)interactive.isDisplayed());
        Assert.assertTrue((boolean)disabled.isDisplayed());
        Assert.assertTrue((boolean)readOnly.isDisplayed());
        msp = driver.findWMultiSelectPair((By)new ByLabel("Hidden", false));
        Assert.assertFalse((boolean)msp.isDisplayed());
    }

    @Test
    public void testGetOptions() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        int expected = SHAPES.length;
        Assert.assertEquals((long)expected, (long)this.getExampleNoSelection().getOptions().size());
        Assert.assertEquals((long)expected, (long)this.getExampleWithSelection().getOptions().size());
        Assert.assertEquals((long)expected, (long)this.getExampleReadOnlyWithSelection().getOptions().size());
        Assert.assertEquals((long)expected, (long)this.getExampleDisabledWithSelection().getOptions().size());
        Assert.assertEquals((long)expected, (long)this.getExampleWithSomeSelection().getOptions().size());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getExampleRadOnlyNoSelection().getOptions()));
        SeleniumWMultiSelectPairWebElement msp = driver.findWMultiSelectPair((By)new ByLabel("No options", false));
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)msp.getOptions()));
    }

    @Test
    public void testGetOption() {
        SeleniumWMultiSelectPairWebElement noSelection = this.getExampleNoSelection();
        SeleniumWMultiSelectPairWebElement withSelection = this.getExampleWithSelection();
        SeleniumWMultiSelectPairWebElement disabled = this.getExampleDisabledWithSelection();
        SeleniumWMultiSelectPairWebElement readOnly = this.getExampleReadOnlyWithSelection();
        SeleniumWMultiSelectPairWebElement msp = this.getExampleWithSomeSelection();
        for (String text : SHAPES) {
            Assert.assertEquals((Object)text, (Object)noSelection.getOption(text).getText());
            Assert.assertEquals((Object)text, (Object)withSelection.getOption(text).getText());
            Assert.assertEquals((Object)text, (Object)readOnly.getOption(text).getText());
            Assert.assertEquals((Object)text, (Object)disabled.getOption(text).getText());
            Assert.assertEquals((Object)text, (Object)msp.getOption(text).getText());
        }
    }

    @Test
    public void testGetSelected() {
        int expected = SHAPES.length;
        Assert.assertEquals((long)expected, (long)this.getExampleWithSelection().getSelected().size());
        Assert.assertEquals((long)expected, (long)this.getExampleReadOnlyWithSelection().getSelected().size());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getExampleDisabledWithSelection().getSelected()));
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getExampleNoSelection().getSelected()));
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getExampleRadOnlyNoSelection().getSelected()));
        SeleniumWMultiSelectPairWebElement msp = this.getExampleWithSomeSelection();
        List options = msp.getSelected();
        Assert.assertEquals((long)3L, (long)options.size());
        for (WebElement option : options) {
            boolean found = false;
            String text = option.getText();
            for (String shape : SHAPES) {
                if (!shape.equals(text)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)"Expected to find a match", (boolean)found);
        }
    }

    @Test
    public void testIsSelected() {
        SeleniumWMultiSelectPairWebElement noSelection = this.getExampleNoSelection();
        SeleniumWMultiSelectPairWebElement withSelection = this.getExampleWithSelection();
        SeleniumWMultiSelectPairWebElement disabled = this.getExampleDisabledWithSelection();
        SeleniumWMultiSelectPairWebElement readOnly = this.getExampleReadOnlyWithSelection();
        SeleniumWMultiSelectPairWebElement readOnlyNoSelection = this.getExampleRadOnlyNoSelection();
        SeleniumWMultiSelectPairWebElement someSelected = this.getExampleWithSomeSelection();
        int i = 0;
        for (String shape : SHAPES) {
            Assert.assertFalse((boolean)noSelection.isSelected(shape));
            Assert.assertTrue((boolean)withSelection.isSelected(shape));
            Assert.assertFalse((boolean)disabled.isSelected(shape));
            Assert.assertTrue((boolean)readOnly.isSelected(shape));
            Assert.assertFalse((boolean)readOnlyNoSelection.isSelected(shape));
            if (i++ % 2 == 0) {
                Assert.assertTrue((boolean)someSelected.isSelected(shape));
                continue;
            }
            Assert.assertFalse((boolean)someSelected.isSelected(shape));
        }
    }

    @Test
    public void testSelect() {
        SeleniumWMultiSelectPairWebElement msp = this.getExampleNoSelection();
        for (String shape : SHAPES) {
            Assert.assertFalse((boolean)msp.isSelected(shape));
            msp.select(shape);
            Assert.assertTrue((boolean)msp.isSelected(shape));
        }
    }

    @Test
    public void testDeselect() {
        SeleniumWMultiSelectPairWebElement msp = this.getExampleWithSelection();
        for (String shape : SHAPES) {
            Assert.assertTrue((boolean)msp.isSelected(shape));
            msp.deselect(shape);
            Assert.assertFalse((boolean)msp.isSelected(shape));
        }
    }

    @Test
    public void testSelectAll() {
        SeleniumWMultiSelectPairWebElement msp = this.getExampleNoSelection();
        for (String shape : SHAPES) {
            Assert.assertFalse((boolean)msp.isSelected(shape));
        }
        msp.selectAll();
        for (String shape : SHAPES) {
            Assert.assertTrue((boolean)msp.isSelected(shape));
        }
    }

    @Test
    public void testDeselectAll() {
        SeleniumWMultiSelectPairWebElement msp = this.getExampleWithSelection();
        for (String shape : SHAPES) {
            Assert.assertTrue((boolean)msp.isSelected(shape));
        }
        msp.deselectAll();
        for (String shape : SHAPES) {
            Assert.assertFalse((boolean)msp.isSelected(shape));
        }
    }
}

