/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples;

import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.examples.SeleniumTests;
import com.github.bordertech.wcomponents.examples.SimpleFileUpload;
import com.github.bordertech.wcomponents.examples.WComponentExamplesTestCase;
import com.github.bordertech.wcomponents.test.selenium.ByWComponent;
import com.github.bordertech.wcomponents.test.selenium.MultiBrowserRunner;
import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;

@Category(value={SeleniumTests.class})
@RunWith(value=MultiBrowserRunner.class)
public class SimpleFileUpload_Test
extends WComponentExamplesTestCase {
    public SimpleFileUpload_Test() {
        super((WComponent)new SimpleFileUpload());
    }

    @Test
    public void testExample() throws IOException {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        Assert.assertEquals((String)"Incorrect default text", (Object)"", (Object)driver.findWTextField((By)this.byWComponentPath("WTextField")).getText());
        driver.findElement((ByWComponent)this.byWComponentPath("WButton")).click();
        Assert.assertEquals((String)"Should not have uploaded", (Object)"nothing uploaded", (Object)driver.findWTextField((By)this.byWComponentPath("WTextField")).getText());
        String testText = "SimpleFileUpload_Test.testExample. The time is: " + new Date();
        File tempFile = SimpleFileUpload_Test.createTempFile(testText);
        driver.findElement((ByWComponent)this.byWComponentPath("WFileWidget")).findElement(By.xpath((String)"descendant-or-self::input")).sendKeys(new CharSequence[]{tempFile.getAbsolutePath()});
        driver.findElement((ByWComponent)this.byWComponentPath("WButton")).click();
        Assert.assertEquals((String)"Incorrect data uploaded", (Object)testText, (Object)driver.findWTextField((By)this.byWComponentPath("WTextField")).getText());
    }

    private static File createTempFile(String content) throws IOException {
        File tempFile = File.createTempFile("SimpleFileUpload_Test", "tmp");
        tempFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tempFile);
        ((OutputStream)out).write(content.getBytes());
        ((OutputStream)out).close();
        return tempFile;
    }
}

