/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples;

import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.examples.SeleniumTests;
import com.github.bordertech.wcomponents.examples.WComponentExamplesTestCase;
import com.github.bordertech.wcomponents.examples.table.SimplePaginationTableWithSelectablesExample;
import com.github.bordertech.wcomponents.test.selenium.ByWComponent;
import com.github.bordertech.wcomponents.test.selenium.MultiBrowserRunner;
import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriver;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWTableWebElement;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;

@Category(value={SeleniumTests.class})
@RunWith(value=MultiBrowserRunner.class)
public class SimplePaginationTableWithSelectablesExample_Test
extends WComponentExamplesTestCase {
    private final String SELECT_BUTTON = "WButton[0]";
    private final String DELETE_BUTTON = "WButton[1]";
    private final String EDIT_BUTTON = "WButton[2]";
    private final String REFRESH_BUTTON = "WButton[3]";

    public SimplePaginationTableWithSelectablesExample_Test() {
        super((WComponent)new SimplePaginationTableWithSelectablesExample());
    }

    @Test
    public void testButtonsDisabledOnLoad() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        Assert.assertFalse((String)"Buttons should be disabled on initial load", (driver.findElement((ByWComponent)this.byWComponentPath("WButton[0]")).isEnabled() && driver.findElement((ByWComponent)this.byWComponentPath("WButton[1]")).isEnabled() && driver.findElement((ByWComponent)this.byWComponentPath("WButton[2]")).isEnabled() ? 1 : 0) != 0);
        SeleniumWTableWebElement wTableWebElement = this.getTable();
        wTableWebElement.getTable().findElement(By.cssSelector((String)"tr[role='row'] td:nth-of-type(3)")).click();
        Assert.assertTrue((String)"Buttons should be enabled", (boolean)driver.findElement((ByWComponent)this.byWComponentPath("WButton[1]")).isEnabled());
        driver.clearUserContext();
    }

    @Test
    public void testActionConstraintsOnSinglePage() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWTableWebElement wTableWebElement = this.getTable();
        for (int i = 0; i < 5; ++i) {
            if (i == 0) {
                Assert.assertFalse((String)"Buttons should be disabled when nothing is selected", (driver.findElement((ByWComponent)this.byWComponentPath("WButton[0]")).isEnabled() && driver.findElement((ByWComponent)this.byWComponentPath("WButton[1]")).isEnabled() && driver.findElement((ByWComponent)this.byWComponentPath("WButton[2]")).isEnabled() ? 1 : 0) != 0);
            }
            if (i == 1) {
                Assert.assertTrue((String)"All buttons should be enabled with one item selected", (driver.findElement((ByWComponent)this.byWComponentPath("WButton[0]")).isEnabled() && driver.findElement((ByWComponent)this.byWComponentPath("WButton[1]")).isEnabled() && driver.findElement((ByWComponent)this.byWComponentPath("WButton[2]")).isEnabled() ? 1 : 0) != 0);
            }
            if (i > 1) {
                Assert.assertFalse((String)"Edit button should be disabled with more than one item selected", (boolean)driver.findElement((ByWComponent)this.byWComponentPath("WButton[2]")).isEnabled());
                Assert.assertTrue((String)"Delete button should be enabled with more than one item selected", (boolean)driver.findElement((ByWComponent)this.byWComponentPath("WButton[1]")).isEnabled());
            }
            if (i > 0 && i < 4) {
                Assert.assertTrue((String)"Select button should be enabled with 1 to 3 items selected", (boolean)driver.findElement((ByWComponent)this.byWComponentPath("WButton[0]")).isEnabled());
            }
            if (i >= 4) {
                Assert.assertFalse((String)"Select button should be disabled with 4 or more items selected", (boolean)driver.findElement((ByWComponent)this.byWComponentPath("WButton[0]")).isEnabled());
            }
            wTableWebElement.getTable().findElement(By.cssSelector((String)("tr[data-wc-rowindex='" + i + "'] td:nth-of-type(3)"))).click();
        }
        driver.clearUserContext();
    }

    @Test
    public void testActionConstraintsAcrossPagesWithRefresh() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWTableWebElement wTableWebElement = this.getTable();
        wTableWebElement.getTable().findElement(By.cssSelector((String)"tr[data-wc-rowindex='0'] td:nth-of-type(3)")).click();
        wTableWebElement.getTable().findElement(By.cssSelector((String)"tr[data-wc-rowindex='1'] td:nth-of-type(3)")).click();
        wTableWebElement.getNextPageButton().click();
        driver.waitForPageReady();
        driver.findElement((ByWComponent)this.byWComponentPath("WButton[3]")).click();
        Assert.assertTrue((String)"Select and delete buttons should be enabled", (driver.findElement((ByWComponent)this.byWComponentPath("WButton[0]")).isEnabled() && driver.findElement((ByWComponent)this.byWComponentPath("WButton[1]")).isEnabled() ? 1 : 0) != 0);
        Assert.assertFalse((String)"Edit button should be disabled", (boolean)driver.findElement((ByWComponent)this.byWComponentPath("WButton[2]")).isEnabled());
        wTableWebElement = this.getTable();
        wTableWebElement.getTable().findElement(By.cssSelector((String)"tr[data-wc-rowindex='5'] td:nth-of-type(3)")).click();
        wTableWebElement.getTable().findElement(By.cssSelector((String)"tr[data-wc-rowindex='6'] td:nth-of-type(3)")).click();
        Assert.assertFalse((String)"Select button should be enabled", (boolean)driver.findElement((ByWComponent)this.byWComponentPath("WButton[0]")).isEnabled());
        wTableWebElement.getPreviousPageButton().click();
        driver.waitForPageReady();
        driver.findElement((ByWComponent)this.byWComponentPath("WButton[3]")).click();
        Assert.assertFalse((String)"Select button should be disabled", (boolean)driver.findElement((ByWComponent)this.byWComponentPath("WButton[0]")).isEnabled());
        wTableWebElement = this.getTable();
        wTableWebElement.getTable().findElement(By.cssSelector((String)"tr[data-wc-rowindex='0'] td:nth-of-type(3)")).click();
        Assert.assertTrue((String)"Select button should be enabled", (boolean)driver.findElement((ByWComponent)this.byWComponentPath("WButton[0]")).isEnabled());
        wTableWebElement.getTable().findElement(By.cssSelector((String)"tr[data-wc-rowindex='0'] td:nth-of-type(3)")).click();
        wTableWebElement.getLastPageButton().click();
        driver.findElement((ByWComponent)this.byWComponentPath("WButton[3]")).click();
        Assert.assertFalse((String)"Select and Edit Buttons should be disabled", (driver.findElement((ByWComponent)this.byWComponentPath("WButton[0]")).isEnabled() && driver.findElement((ByWComponent)this.byWComponentPath("WButton[2]")).isEnabled() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Delete button should be enabled", (boolean)driver.findElement((ByWComponent)this.byWComponentPath("WButton[1]")).isEnabled());
        driver.clearUserContext();
    }

    @Test
    public void testActionConstraintsAcrossPagesWithoutRefresh() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWTableWebElement wTableWebElement = this.getTable();
        wTableWebElement.getTable().findElement(By.cssSelector((String)"tr[data-wc-rowindex='0'] td:nth-of-type(3)")).click();
        wTableWebElement.getTable().findElement(By.cssSelector((String)"tr[data-wc-rowindex='1'] td:nth-of-type(3)")).click();
        wTableWebElement.getNextPageButton().click();
        driver.waitForPageReady();
        Assert.assertTrue((String)"Select and delete buttons should be enabled", (driver.findElement((ByWComponent)this.byWComponentPath("WButton[0]")).isEnabled() && driver.findElement((ByWComponent)this.byWComponentPath("WButton[1]")).isEnabled() ? 1 : 0) != 0);
        Assert.assertFalse((String)"Edit button should be disabled", (boolean)driver.findElement((ByWComponent)this.byWComponentPath("WButton[2]")).isEnabled());
        wTableWebElement = this.getTable();
        wTableWebElement.getTable().findElement(By.cssSelector((String)"tr[data-wc-rowindex='5'] td:nth-of-type(3)")).click();
        wTableWebElement.getTable().findElement(By.cssSelector((String)"tr[data-wc-rowindex='6'] td:nth-of-type(3)")).click();
        Assert.assertFalse((String)"Select button should be enabled", (boolean)driver.findElement((ByWComponent)this.byWComponentPath("WButton[0]")).isEnabled());
        wTableWebElement.getPreviousPageButton().click();
        driver.waitForPageReady();
        Assert.assertFalse((String)"Select button should be disabled", (boolean)driver.findElement((ByWComponent)this.byWComponentPath("WButton[0]")).isEnabled());
        wTableWebElement = this.getTable();
        wTableWebElement.getTable().findElement(By.cssSelector((String)"tr[data-wc-rowindex='0'] td:nth-of-type(3)")).click();
        Assert.assertTrue((String)"Select button should be enabled", (boolean)driver.findElement((ByWComponent)this.byWComponentPath("WButton[0]")).isEnabled());
        wTableWebElement.getTable().findElement(By.cssSelector((String)"tr[data-wc-rowindex='0'] td:nth-of-type(3)")).click();
        wTableWebElement.getLastPageButton().click();
        Assert.assertFalse((String)"Select and Edit Buttons should be disabled", (driver.findElement((ByWComponent)this.byWComponentPath("WButton[0]")).isEnabled() && driver.findElement((ByWComponent)this.byWComponentPath("WButton[2]")).isEnabled() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Delete button should be enabled", (boolean)driver.findElement((ByWComponent)this.byWComponentPath("WButton[1]")).isEnabled());
        driver.clearUserContext();
    }

    private SeleniumWTableWebElement getTable() {
        return this.getDriver().findWTable((By)this.byWComponentPath("WTable"));
    }
}

