/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples;

import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.examples.SeleniumTests;
import com.github.bordertech.wcomponents.examples.WComponentExamplesTestCase;
import com.github.bordertech.wcomponents.examples.table.SimplePaginationWithRowOptionsTableExample;
import com.github.bordertech.wcomponents.test.selenium.MultiBrowserRunner;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWTableWebElement;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;

@Category(value={SeleniumTests.class})
@RunWith(value=MultiBrowserRunner.class)
public class SimplePaginationWithRowOptionsTableExample_Test
extends WComponentExamplesTestCase {
    public SimplePaginationWithRowOptionsTableExample_Test() {
        super((WComponent)new SimplePaginationWithRowOptionsTableExample());
    }

    @Test
    public void testPagination() {
        SeleniumWTableWebElement table = this.getTable();
        Assert.assertEquals((String)"Unexpected column header.", (Object)"First name", (Object)table.getHeaderTextForColumn(0));
        Assert.assertEquals((String)"Unexpected column header.", (Object)"Last name", (Object)table.getHeaderTextForColumn(1));
        Assert.assertEquals((String)"Unexpected column header.", (Object)"DOB", (Object)table.getHeaderTextForColumn(2));
        int totalRows = table.getTotalRows();
        int currentPage = table.getCurrentPage();
        int rowsPerPage = table.getRowsPerPage();
        int totalPages = table.getTotalPages();
        Assert.assertEquals((String)"Expected 16 total rows", (long)16L, (long)totalRows);
        Assert.assertEquals((String)"Expected to load first page in table.", (long)1L, (long)currentPage);
        Assert.assertEquals((String)"Expected 2 rows per page by default.", (long)2L, (long)rowsPerPage);
        int expectedTotalPages = (int)Math.floor(totalRows / rowsPerPage);
        Assert.assertEquals((String)"Expected total pages to match.", (long)expectedTotalPages, (long)totalPages);
        Assert.assertEquals((String)"Expected table caption to match", (Object)"TABLE CAPTION", (Object)table.getTableCaption());
        this.assertRowContent(table, 0, "Joe", "Bloggs", "01 Feb 1973");
        this.assertRowContent(table, 1, "Richard", "Starkey", "04 Aug 1976");
        int firstIndex = 1;
        this.assertPageButtons(table, firstIndex, firstIndex + 1, false, true);
        table.getNextPageButton().click();
        table = this.getTable();
        this.assertPageButtons(table, firstIndex + rowsPerPage, firstIndex + rowsPerPage + 1, true, true);
        table.getLastPageButton().click();
        table = this.getTable();
        this.assertPageButtons(table, totalRows - 1, totalRows, true, false);
        table.getPreviousPageButton().click();
        table = this.getTable();
        this.assertPageButtons(table, totalRows - rowsPerPage - 1, totalRows - rowsPerPage, true, true);
    }

    private void assertPageButtons(SeleniumWTableWebElement table, int firstResult, int lastResult, boolean backwardsButtonsEnabled, boolean forwardsButtonsEnabled) {
        Assert.assertEquals((String)"First row index on page does not match expected.", (long)firstResult, (long)table.getFirstRowIndexOfPage());
        Assert.assertEquals((String)"Last row index on page does not match expected", (long)lastResult, (long)table.getLastRowIndexOfPage());
        Assert.assertEquals((String)"First page button in unexpected state", (Object)backwardsButtonsEnabled, (Object)table.getFirstPageButton().isEnabled());
        Assert.assertEquals((String)"Previous page button in unexpected state", (Object)backwardsButtonsEnabled, (Object)table.getPreviousPageButton().isEnabled());
        Assert.assertEquals((String)"Next page button in unexpected state", (Object)forwardsButtonsEnabled, (Object)table.getNextPageButton().isEnabled());
        Assert.assertEquals((String)"Last page button in unexpected state", (Object)forwardsButtonsEnabled, (Object)table.getLastPageButton().isEnabled());
    }

    private void assertRowContent(SeleniumWTableWebElement table, int row, String ... cellContent) {
        for (int i = 0; i < cellContent.length; ++i) {
            Assert.assertEquals((String)("Unexpected cell content for row:column" + row + ":" + i), (Object)cellContent[i], (Object)table.getCellText(row, i));
        }
    }

    private SeleniumWTableWebElement getTable() {
        return this.getDriver().findWTable(By.id((String)"TABLEID"));
    }
}

