/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples;

import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.WText;
import com.github.bordertech.wcomponents.examples.SeleniumTests;
import com.github.bordertech.wcomponents.examples.SimpleTabs;
import com.github.bordertech.wcomponents.examples.WComponentExamplesTestCase;
import com.github.bordertech.wcomponents.test.selenium.MultiBrowserRunner;
import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriver;
import java.io.IOException;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;

@Category(value={SeleniumTests.class})
@RunWith(value=MultiBrowserRunner.class)
public class SimpleTabs_Test
extends WComponentExamplesTestCase {
    public SimpleTabs_Test() {
        super(SimpleTabs_Test.createSimpleTabs());
    }

    private static WComponent createSimpleTabs() {
        SimpleTabs tabs = new SimpleTabs();
        tabs.addTab((WComponent)new WText("tab1content", new Serializable[0]), "tab1name");
        tabs.addTab((WComponent)new WText("tab2content", new Serializable[0]), "tab2name");
        tabs.addTab((WComponent)new WText("tab3content", new Serializable[0]), "tab3name");
        return tabs;
    }

    @Test
    public void testExample() throws IOException {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        this.assertTabVisible(1);
        driver.findElement((By)this.byWComponentPath("WButton[0]")).click();
        this.assertTabVisible(1);
        driver.findElement((By)this.byWComponentPath("WButton[1]")).click();
        this.assertTabVisible(2);
        driver.findElement((By)this.byWComponentPath("WButton[2]")).click();
        this.assertTabVisible(3);
    }

    private void assertTabVisible(int index) {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        String pageSource = driver.getPageSource();
        for (int i = 1; i <= 3; ++i) {
            String tabHeading = "[tab" + i + "name]:";
            String tabContent = "tab" + i + "content";
            if (i == index) {
                Assert.assertTrue((String)("Tab " + i + " heading should be visible"), (boolean)pageSource.contains(tabHeading));
                Assert.assertTrue((String)("Tab " + i + " content should be visible"), (boolean)pageSource.contains(tabContent));
                continue;
            }
            Assert.assertFalse((String)("Tab " + i + " heading should not be visible"), (boolean)pageSource.contains(tabHeading));
            Assert.assertFalse((String)("Tab " + i + " content should not be visible"), (boolean)pageSource.contains(tabContent));
        }
    }
}

