/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples.theme;

import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.examples.SeleniumTests;
import com.github.bordertech.wcomponents.examples.WComponentExamplesTestCase;
import com.github.bordertech.wcomponents.examples.theme.WCheckBoxSelectExample;
import com.github.bordertech.wcomponents.test.selenium.ByLabel;
import com.github.bordertech.wcomponents.test.selenium.MultiBrowserRunner;
import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriver;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWCheckBoxSelectWebElement;
import com.github.bordertech.wcomponents.util.SystemException;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@Category(value={SeleniumTests.class})
@RunWith(value=MultiBrowserRunner.class)
public class WCheckBoxSelectExample_Test
extends WComponentExamplesTestCase {
    public WCheckBoxSelectExample_Test() {
        super((WComponent)new WCheckBoxSelectExample());
    }

    private SeleniumWCheckBoxSelectWebElement getExampleNoSelections() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        return driver.findWCheckBoxSelect((By)this.byWComponentPath("WCheckBoxSelect[0]"));
    }

    private SeleniumWCheckBoxSelectWebElement getExampleWithSelections() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        return driver.findWCheckBoxSelect((By)new ByLabel("Many selections with frame", false));
    }

    private SeleniumWCheckBoxSelectWebElement getExampleWithReadOnlySelection() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        return driver.findWCheckBoxSelect((By)new ByLabel("Many selections with frame (read only)", false));
    }

    private SeleniumWCheckBoxSelectWebElement getDisabledExample() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        return driver.findWCheckBoxSelect((By)new ByLabel("Disabled with no default selection", false));
    }

    private SeleniumWCheckBoxSelectWebElement getExampleNoOptions() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        return driver.findWCheckBoxSelect((By)new ByLabel("WCheckBoxSelect with no options", false));
    }

    private SeleniumWCheckBoxSelectWebElement getReadOnlyNoSelection() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        return driver.findWCheckBoxSelect((By)new ByLabel("No selections were made (read only)", false));
    }

    @Test
    public void testWCheckBoxSelect() {
        Assert.assertNotNull((Object)this.getExampleNoSelections());
        Assert.assertNotNull((Object)this.getExampleWithReadOnlySelection());
        Assert.assertNotNull((Object)this.getDisabledExample());
    }

    @Test
    public void testComponentLevelBooleanProperties() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWCheckBoxSelectWebElement interactive = this.getExampleNoSelections();
        SeleniumWCheckBoxSelectWebElement readOnly = this.getExampleWithReadOnlySelection();
        SeleniumWCheckBoxSelectWebElement disabled = this.getDisabledExample();
        Assert.assertFalse((boolean)interactive.isReadOnly());
        Assert.assertTrue((boolean)readOnly.isReadOnly());
        Assert.assertFalse((boolean)disabled.isReadOnly());
        Assert.assertTrue((boolean)interactive.isEnabled());
        Assert.assertFalse((boolean)readOnly.isEnabled());
        Assert.assertFalse((boolean)disabled.isEnabled());
        Assert.assertFalse((boolean)interactive.isMandatory());
        Assert.assertFalse((boolean)readOnly.isMandatory());
        Assert.assertFalse((boolean)disabled.isMandatory());
        SeleniumWCheckBoxSelectWebElement cbs = driver.findWCheckBoxSelect((By)new ByLabel("A selection is required", true));
        Assert.assertTrue((boolean)cbs.isMandatory());
    }

    @Test
    public void testGetOptions() {
        Assert.assertEquals((long)9L, (long)this.getExampleNoSelections().getOptions().size());
        Assert.assertEquals((long)9L, (long)this.getExampleWithReadOnlySelection().getOptions().size());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getExampleNoOptions().getOptions()));
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getReadOnlyNoSelection().getOptions()));
    }

    @Test
    public void testGetOption() {
        SeleniumWCheckBoxSelectWebElement interactive = this.getExampleNoSelections();
        SeleniumWCheckBoxSelectWebElement readOnly = this.getExampleWithReadOnlySelection();
        Assert.assertNotNull((Object)interactive.getOption(0));
        Assert.assertNotNull((Object)readOnly.getOption(0));
        Assert.assertNotNull((Object)interactive.getOption("Outside Australia"));
        Assert.assertNotNull((Object)readOnly.getOption("Outside Australia"));
    }

    @Test
    public void testGetInput() {
        SeleniumWCheckBoxSelectWebElement cbs = this.getExampleNoSelections();
        Assert.assertNotNull((Object)cbs.getInput(0));
        Assert.assertNotNull((Object)cbs.getInput("Tasmania"));
        WebElement option = cbs.getOption(0);
        Assert.assertNotNull((Object)cbs.getInput(option));
    }

    @Test
    public void testGetSelected() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        Assert.assertEquals((long)9L, (long)this.getExampleWithSelections().getSelected().size());
        Assert.assertEquals((long)9L, (long)this.getExampleWithReadOnlySelection().getSelected().size());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getExampleNoSelections().getSelected()));
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getReadOnlyNoSelection().getSelected()));
        SeleniumWCheckBoxSelectWebElement cbs = driver.findWCheckBoxSelect((By)new ByLabel("One selection was made", false));
        Assert.assertEquals((long)1L, (long)cbs.getSelected().size());
        cbs = driver.findWCheckBoxSelect((By)new ByLabel("One selection was made (read only)", false));
        Assert.assertEquals((long)1L, (long)cbs.getSelected().size());
        cbs = driver.findWCheckBoxSelect((By)new ByLabel("Disabled with many selections and COLUMN layout", false));
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)cbs.getSelected()));
    }

    @Test
    public void testIsSelected() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWCheckBoxSelectWebElement interactive = driver.findWCheckBoxSelect((By)new ByLabel("One selection was made", false));
        SeleniumWCheckBoxSelectWebElement readOnly = driver.findWCheckBoxSelect((By)new ByLabel("One selection was made (read only)", false));
        Assert.assertTrue((boolean)interactive.isSelected(0));
        Assert.assertFalse((boolean)interactive.isSelected(1));
        Assert.assertTrue((boolean)readOnly.isSelected(0));
        Assert.assertFalse((boolean)readOnly.isSelected(1));
        String labelText = "Outside Australia";
        Assert.assertTrue((boolean)interactive.isSelected(labelText));
        Assert.assertFalse((boolean)interactive.isSelected("Australian Capital Territory"));
        Assert.assertTrue((boolean)readOnly.isSelected(labelText));
        Assert.assertFalse((boolean)readOnly.isSelected("Australian Capital Territory"));
        Assert.assertTrue((boolean)interactive.isSelected(interactive.getOption(0)));
        Assert.assertFalse((boolean)interactive.isSelected(interactive.getOption(1)));
        Assert.assertTrue((boolean)readOnly.isSelected(readOnly.getOption(0)));
        SeleniumWCheckBoxSelectWebElement disabled = driver.findWCheckBoxSelect((By)new ByLabel("Disabled with many selections and COLUMN layout", false));
        int i = 0;
        for (WebElement option : disabled.getOptions()) {
            Assert.assertFalse((boolean)disabled.isSelected(option));
            Assert.assertFalse((boolean)disabled.isSelected(i++));
            Assert.assertFalse((boolean)disabled.isSelected(option.getText()));
        }
    }

    @Test
    public void testSelect() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWCheckBoxSelectWebElement cbs = this.getExampleNoSelections();
        WebElement option = cbs.getOption(0);
        Assert.assertFalse((boolean)cbs.isSelected(option));
        cbs.select(option);
        Assert.assertTrue((String)"Option should be selected", (boolean)cbs.isSelected(option));
        int idx = 1;
        Assert.assertFalse((boolean)cbs.isSelected(idx));
        cbs.select(idx);
        Assert.assertTrue((String)"Option at index 'idx' should be selected", (boolean)cbs.isSelected(idx));
        String labelText = "South Australia";
        Assert.assertFalse((boolean)cbs.isSelected(labelText));
        cbs.select(labelText);
        Assert.assertTrue((String)("Option labelled '" + labelText + "' should be selected"), (boolean)cbs.isSelected(labelText));
        cbs = driver.findWCheckBoxSelect((By)new ByLabel("One selection was made", false));
        idx = 0;
        Assert.assertTrue((boolean)cbs.isSelected(idx));
        cbs.select(idx);
        Assert.assertTrue((String)"Option should still be selected", (boolean)cbs.isSelected(idx));
        cbs = this.getDisabledExample();
        Assert.assertFalse((boolean)cbs.isSelected(0));
        cbs.select(0);
        this.getDriver().waitForPageReady();
        Assert.assertFalse((boolean)cbs.isSelected(0));
        cbs = this.getExampleWithReadOnlySelection();
        Assert.assertTrue((boolean)cbs.isSelected(0));
        cbs.select(0);
        this.getDriver().waitForPageReady();
        Assert.assertTrue((boolean)cbs.isSelected(0));
    }

    @Test
    public void testDeselect() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWCheckBoxSelectWebElement cbs = this.getExampleWithSelections();
        WebElement option = cbs.getOption(0);
        Assert.assertTrue((boolean)cbs.isSelected(option));
        cbs.deselect(option);
        Assert.assertFalse((String)"Option should not selected", (boolean)cbs.isSelected(option));
        int idx = 1;
        Assert.assertTrue((boolean)cbs.isSelected(idx));
        cbs.deselect(idx);
        Assert.assertFalse((String)"Option at index 'idx' should not be selected", (boolean)cbs.isSelected(idx));
        String labelText = "South Australia";
        Assert.assertTrue((boolean)cbs.isSelected(labelText));
        cbs.deselect(labelText);
        Assert.assertFalse((String)("Option labelled '" + labelText + "' should not be selected"), (boolean)cbs.isSelected(labelText));
        cbs = driver.findWCheckBoxSelect((By)new ByLabel("One selection was made", false));
        idx = 1;
        Assert.assertFalse((boolean)cbs.isSelected(idx));
        cbs.deselect(idx);
        Assert.assertFalse((String)"Option should still not be selected", (boolean)cbs.isSelected(idx));
        cbs = this.getExampleWithReadOnlySelection();
        Assert.assertTrue((boolean)cbs.isSelected(0));
        cbs.deselect(0);
        this.getDriver().waitForPageReady();
        Assert.assertTrue((boolean)cbs.isSelected(0));
    }

    @Test
    public void testClick() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWCheckBoxSelectWebElement cbs = driver.findWCheckBoxSelect((By)new ByLabel("One selection was made", false));
        WebElement option = cbs.getOption(0);
        boolean selected = cbs.isSelected(option);
        cbs.clickNoWait(option);
        Assert.assertEquals((String)"Option selection should have changed.", (Object)(!selected ? 1 : 0), (Object)cbs.isSelected(option));
        cbs.clickNoWait(option);
        Assert.assertEquals((String)"Option selection should have changed back.", (Object)selected, (Object)cbs.isSelected(option));
        String labelText = "New South Wales";
        selected = cbs.isSelected(labelText);
        cbs.clickNoWait(labelText);
        Assert.assertEquals((String)("Option with label '" + labelText + "' selection should have changed."), (Object)(!selected ? 1 : 0), (Object)cbs.isSelected(labelText));
        cbs.clickNoWait(labelText);
        Assert.assertEquals((String)("Option with label '" + labelText + "' selection should have changed back."), (Object)selected, (Object)cbs.isSelected(labelText));
        int idx = 3;
        selected = cbs.isSelected(idx);
        cbs.clickNoWait(idx);
        Assert.assertEquals((String)("Option with index '" + String.valueOf(idx) + "' selection should have changed."), (Object)(!selected ? 1 : 0), (Object)cbs.isSelected(idx));
        cbs.clickNoWait(idx);
        Assert.assertEquals((String)("Option with index '" + String.valueOf(idx) + "' selection should have changed back."), (Object)selected, (Object)cbs.isSelected(idx));
        cbs = this.getDisabledExample();
        Assert.assertFalse((boolean)cbs.isSelected(0));
        cbs.clickNoWait(0);
        this.getDriver().waitForPageReady();
        Assert.assertFalse((boolean)cbs.isSelected(0));
        cbs = this.getExampleWithReadOnlySelection();
        Assert.assertTrue((boolean)cbs.isSelected(0));
        cbs.clickNoWait(0);
        this.getDriver().waitForPageReady();
        Assert.assertTrue((boolean)cbs.isSelected(0));
    }

    @Test
    public void testToggle() {
        SeleniumWCheckBoxSelectWebElement cbs = this.getExampleNoSelections();
        WebElement option = cbs.getOption(0);
        boolean selected = cbs.isSelected(option);
        cbs.toggle(option);
        Assert.assertEquals((String)"Option should not be in the same selected state", (Object)(!selected ? 1 : 0), (Object)cbs.isSelected(option));
        cbs.toggle(option);
        Assert.assertEquals((String)"Option should be back in the previous selected state", (Object)selected, (Object)cbs.isSelected(option));
        String labelText = "New South Wales";
        selected = cbs.isSelected(labelText);
        cbs.toggle(labelText);
        Assert.assertEquals((String)"Option with label should not be in the same selected state", (Object)(!selected ? 1 : 0), (Object)cbs.isSelected(labelText));
        cbs.toggle(labelText);
        Assert.assertEquals((String)"Option with label should be back in the previous selected state", (Object)selected, (Object)cbs.isSelected(labelText));
        int idx = 3;
        selected = cbs.isSelected(idx);
        cbs.toggle(idx);
        Assert.assertEquals((String)"Option `idx` should not be in the same selected state", (Object)(!selected ? 1 : 0), (Object)cbs.isSelected(idx));
        cbs.toggle(idx);
        Assert.assertEquals((String)"Option `idx` should be back in the previous selected state", (Object)selected, (Object)cbs.isSelected(idx));
        cbs = this.getDisabledExample();
        Assert.assertFalse((boolean)cbs.isSelected(0));
        cbs.toggle(0);
        this.getDriver().waitForPageReady();
        Assert.assertFalse((boolean)cbs.isSelected(0));
        cbs = this.getExampleWithReadOnlySelection();
        Assert.assertTrue((boolean)cbs.isSelected(0));
        cbs.toggle(0);
        this.getDriver().waitForPageReady();
        Assert.assertTrue((boolean)cbs.isSelected(0));
    }

    @Test(expected=SystemException.class)
    public void testGetOptionByIdxWhenEmptyNotReadOnly() {
        this.getExampleNoOptions().getOption(0);
    }

    @Test(expected=SystemException.class)
    public void testGetOptionByTextWhenEmptyNotReadOnly() {
        this.getExampleNoOptions().getOption("");
    }

    @Test(expected=SystemException.class)
    public void testGetOptionReadOnlyNoOptions() {
        this.getReadOnlyNoSelection().getOption(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetOptionWithTextNoOptionReadOnly() {
        this.getExampleWithReadOnlySelection().getOption("USA");
    }

    @Test(expected=SystemException.class)
    public void testGetInputByIdxReadOnly() {
        this.getExampleWithReadOnlySelection().getInput(0);
    }

    @Test(expected=SystemException.class)
    public void testGetInputByTextReadOnly() {
        this.getExampleWithReadOnlySelection().getInput("Tasmania");
    }
}

