/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.examples.theme;

import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.examples.SeleniumTests;
import com.github.bordertech.wcomponents.examples.WComponentExamplesTestCase;
import com.github.bordertech.wcomponents.examples.theme.WRadioButtonSelectExample;
import com.github.bordertech.wcomponents.test.selenium.ByLabel;
import com.github.bordertech.wcomponents.test.selenium.MultiBrowserRunner;
import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriver;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWRadioButtonSelectWebElement;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@Category(value={SeleniumTests.class})
@RunWith(value=MultiBrowserRunner.class)
public class WRadioButtonSelectExample_Test
extends WComponentExamplesTestCase {
    private SeleniumWRadioButtonSelectWebElement getExampleNoSelection() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        return driver.findWRadioButtonSelect((By)new ByLabel("Select a state or territory", false));
    }

    private SeleniumWRadioButtonSelectWebElement getExampleWithSelection() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        return driver.findWRadioButtonSelect((By)new ByLabel("Frameless with default selection", false));
    }

    private SeleniumWRadioButtonSelectWebElement getReadOnlyExampleNoSelection() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        return driver.findWRadioButtonSelect((By)new ByLabel("Read only with no selection", false));
    }

    private SeleniumWRadioButtonSelectWebElement getReadOnlyExampleWithSelection() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        return driver.findWRadioButtonSelect((By)new ByLabel("Read only with selection", false));
    }

    private SeleniumWRadioButtonSelectWebElement getDisabledExample() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        return driver.findWRadioButtonSelect((By)new ByLabel("Disabled with selection", false));
    }

    public WRadioButtonSelectExample_Test() {
        super((WComponent)new WRadioButtonSelectExample());
    }

    @Test
    public void testFindWRadioButtonSelect() {
        Assert.assertNotNull((Object)this.getExampleNoSelection());
        Assert.assertNotNull((Object)this.getReadOnlyExampleNoSelection());
        Assert.assertNotNull((Object)this.getDisabledExample());
    }

    @Test
    public void testComponentLevelProperties() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        SeleniumWRadioButtonSelectWebElement interactive = this.getExampleNoSelection();
        SeleniumWRadioButtonSelectWebElement disabled = this.getDisabledExample();
        SeleniumWRadioButtonSelectWebElement readOnly = this.getReadOnlyExampleWithSelection();
        Assert.assertFalse((boolean)interactive.isReadOnly());
        Assert.assertFalse((boolean)disabled.isReadOnly());
        Assert.assertTrue((boolean)readOnly.isReadOnly());
        Assert.assertTrue((boolean)interactive.isEnabled());
        Assert.assertFalse((boolean)disabled.isEnabled());
        Assert.assertFalse((boolean)readOnly.isEnabled());
        Assert.assertFalse((boolean)interactive.isMandatory());
        Assert.assertFalse((boolean)readOnly.isMandatory());
        Assert.assertFalse((boolean)disabled.isMandatory());
        SeleniumWRadioButtonSelectWebElement cbs = driver.findWRadioButtonSelect((By)new ByLabel("Mandatory selection", false));
        Assert.assertTrue((boolean)cbs.isMandatory());
    }

    @Test
    public void testGetOptions() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        Assert.assertEquals((long)9L, (long)this.getExampleNoSelection().getOptions().size());
        Assert.assertEquals((long)9L, (long)this.getDisabledExample().getOptions().size());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getReadOnlyExampleNoSelection().getOptions()));
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)driver.findWRadioButtonSelect((By)new ByLabel("Select from no options", false)).getOptions()));
    }

    @Test
    public void testGetOption() {
        SeleniumWRadioButtonSelectWebElement interactive = this.getExampleNoSelection();
        SeleniumWRadioButtonSelectWebElement disabled = this.getDisabledExample();
        SeleniumWRadioButtonSelectWebElement readOnly = this.getReadOnlyExampleWithSelection();
        Assert.assertNotNull((Object)interactive.getOption(0));
        Assert.assertNotNull((Object)readOnly.getOption(0));
        Assert.assertNotNull((Object)disabled.getOption(0));
        Assert.assertNotNull((Object)interactive.getOption("Outside Australia"));
        Assert.assertNotNull((Object)readOnly.getOption("Outside Australia"));
        Assert.assertNotNull((Object)disabled.getOption("Outside Australia"));
    }

    @Test
    public void testGetInput() {
        SeleniumWRadioButtonSelectWebElement rbs = this.getExampleNoSelection();
        Assert.assertNotNull((Object)rbs.getInput(0));
        Assert.assertNotNull((Object)rbs.getInput("Tasmania"));
        WebElement option = rbs.getOption(0);
        Assert.assertNotNull((Object)rbs.getInput(option));
    }

    @Test
    public void testGetSelected() {
        Assert.assertEquals((long)1L, (long)this.getExampleWithSelection().getSelected().size());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getDisabledExample().getSelected()));
        Assert.assertEquals((long)1L, (long)this.getReadOnlyExampleWithSelection().getSelected().size());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getExampleNoSelection().getSelected()));
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getReadOnlyExampleNoSelection().getSelected()));
    }

    @Test
    public void testIsSelected() {
        SeleniumWRadioButtonSelectWebElement rbs = this.getExampleWithSelection();
        Assert.assertTrue((boolean)rbs.isSelected(0));
        Assert.assertFalse((boolean)rbs.isSelected(1));
        Assert.assertTrue((boolean)rbs.isSelected("Outside Australia"));
        Assert.assertFalse((boolean)rbs.isSelected("Victoria"));
        WebElement option = rbs.getOption(0);
        Assert.assertTrue((boolean)rbs.isSelected(option));
        option = rbs.getOption(3);
        Assert.assertFalse((boolean)rbs.isSelected(option));
        rbs = this.getReadOnlyExampleWithSelection();
        Assert.assertTrue((boolean)rbs.isSelected(0));
        Assert.assertFalse((boolean)rbs.isSelected(1));
        Assert.assertTrue((boolean)rbs.isSelected("Outside Australia"));
        Assert.assertFalse((boolean)rbs.isSelected("Victoria"));
        option = rbs.getOption(0);
        Assert.assertTrue((boolean)rbs.isSelected(option));
        rbs = this.getDisabledExample();
        Assert.assertFalse((boolean)rbs.isSelected(0));
        Assert.assertFalse((boolean)rbs.isSelected(1));
        Assert.assertFalse((boolean)rbs.isSelected("Outside Australia"));
        Assert.assertFalse((boolean)rbs.isSelected("Victoria"));
        option = rbs.getOption(0);
        Assert.assertFalse((boolean)rbs.isSelected(option));
        option = rbs.getOption(3);
        Assert.assertFalse((boolean)rbs.isSelected(option));
    }

    @Test
    public void testSelect() {
        SeleniumWRadioButtonSelectWebElement rbs = this.getExampleNoSelection();
        Assert.assertFalse((boolean)rbs.isSelected(0));
        rbs.select(0);
        Assert.assertTrue((boolean)rbs.isSelected(0));
        rbs.select(1);
        Assert.assertFalse((boolean)rbs.isSelected(0));
        Assert.assertTrue((boolean)rbs.isSelected(1));
        Assert.assertFalse((boolean)rbs.isSelected("Outside Australia"));
        rbs.select("Outside Australia");
        Assert.assertTrue((boolean)rbs.isSelected("Outside Australia"));
        rbs.select("Victoria");
        Assert.assertFalse((boolean)rbs.isSelected("Outside Australia"));
        Assert.assertTrue((boolean)rbs.isSelected("Victoria"));
        WebElement option = rbs.getOption(0);
        Assert.assertFalse((boolean)rbs.isSelected(option));
        rbs.select(option);
        Assert.assertTrue((boolean)rbs.isSelected(option));
        WebElement option2 = rbs.getOption(1);
        Assert.assertFalse((boolean)rbs.isSelected(option2));
        rbs.select(option2);
        Assert.assertTrue((boolean)rbs.isSelected(option2));
        Assert.assertFalse((boolean)rbs.isSelected(option));
        rbs = this.getExampleWithSelection();
        Assert.assertTrue((boolean)rbs.isSelected(0));
        rbs.select(0);
        this.getDriver().waitForPageReady();
        Assert.assertTrue((boolean)rbs.isSelected(0));
        rbs = this.getDisabledExample();
        Assert.assertFalse((boolean)rbs.isSelected(0));
        rbs.select(0);
        Assert.assertFalse((boolean)rbs.isSelected(0));
        rbs.select(1);
        Assert.assertFalse((boolean)rbs.isSelected(0));
        Assert.assertFalse((boolean)rbs.isSelected(1));
        rbs = this.getReadOnlyExampleWithSelection();
        Assert.assertTrue((boolean)rbs.isSelected(0));
        rbs.select(0);
        Assert.assertTrue((boolean)rbs.isSelected(0));
    }

    @Test
    public void testClick() {
        SeleniumWRadioButtonSelectWebElement rbs = this.getExampleNoSelection();
        Assert.assertFalse((boolean)rbs.isSelected(0));
        rbs.clickNoWait(0);
        Assert.assertTrue((boolean)rbs.isSelected(0));
        rbs.clickNoWait(1);
        Assert.assertFalse((boolean)rbs.isSelected(0));
        Assert.assertTrue((boolean)rbs.isSelected(1));
        Assert.assertFalse((boolean)rbs.isSelected("Outside Australia"));
        rbs.clickNoWait("Outside Australia");
        Assert.assertTrue((boolean)rbs.isSelected("Outside Australia"));
        rbs.clickNoWait("Victoria");
        Assert.assertFalse((boolean)rbs.isSelected("Outside Australia"));
        Assert.assertTrue((boolean)rbs.isSelected("Victoria"));
        WebElement option = rbs.getOption(0);
        Assert.assertFalse((boolean)rbs.isSelected(option));
        rbs.clickNoWait(option);
        Assert.assertTrue((boolean)rbs.isSelected(option));
        WebElement option2 = rbs.getOption(1);
        Assert.assertFalse((boolean)rbs.isSelected(option2));
        rbs.clickNoWait(option2);
        Assert.assertTrue((boolean)rbs.isSelected(option2));
        Assert.assertFalse((boolean)rbs.isSelected(option));
        rbs = this.getExampleWithSelection();
        Assert.assertTrue((boolean)rbs.isSelected(0));
        rbs.clickNoWait(0);
        this.getDriver().waitForPageReady();
        Assert.assertTrue((boolean)rbs.isSelected(0));
        rbs = this.getDisabledExample();
        Assert.assertFalse((boolean)rbs.isSelected(0));
        rbs.clickNoWait(0);
        Assert.assertFalse((boolean)rbs.isSelected(0));
        rbs.clickNoWait(1);
        Assert.assertFalse((boolean)rbs.isSelected(0));
        Assert.assertFalse((boolean)rbs.isSelected(1));
        rbs = this.getReadOnlyExampleWithSelection();
        Assert.assertTrue((boolean)rbs.isSelected(0));
        rbs.clickNoWait(0);
        Assert.assertTrue((boolean)rbs.isSelected(0));
    }
}

