/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.qa.findbugs;

import com.github.bordertech.wcomponents.qa.findbugs.Util;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XMethod;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;

public class CheckComponentModelDefinition
extends BytecodeScanningDetector {
    private final Util util;

    public CheckComponentModelDefinition(BugReporter bugReporter) {
        this.util = new Util(bugReporter);
    }

    public boolean shouldVisit(JavaClass obj) {
        return this.util.isComponentModel(obj);
    }

    public void visitClassContext(ClassContext classContext) {
        if (!this.util.isComponentModel(classContext.getJavaClass())) {
            return;
        }
        boolean isStatic = false;
        if (classContext.getXClass().getImmediateEnclosingClass() != null) {
            for (Attribute attribute : classContext.getJavaClass().getAttributes()) {
                if (!(attribute instanceof InnerClasses)) continue;
                InnerClass inner = ((InnerClasses)attribute).getInnerClasses()[0];
                isStatic = (inner.getInnerAccessFlags() & 8) != 0;
                break;
            }
        }
        if (!classContext.getXClass().isPublic() || classContext.getClassDescriptor().isAnonymousClass()) {
            this.reportBug(classContext);
        } else if (classContext.getXClass().getImmediateEnclosingClass() != null && !isStatic) {
            this.reportBug(classContext);
        } else {
            boolean foundPublicNoArgsConstructor = false;
            boolean foundConstructor = false;
            for (XMethod method : classContext.getXClass().getXMethods()) {
                if (!"<init>".equals(method.getMethodDescriptor().getName())) continue;
                foundConstructor = true;
                if (!method.isPublic() || method.getNumParams() != 0) continue;
                foundPublicNoArgsConstructor = true;
                break;
            }
            if (foundConstructor && !foundPublicNoArgsConstructor) {
                this.reportBug(classContext);
            }
        }
    }

    private void reportBug(ClassContext classContext) {
        this.util.getBugReporter().reportBug(new BugInstance((Detector)this, "WCCM_NO_PUBLIC_CONSTRUCTOR", 1).addClass(classContext.getClassDescriptor()));
    }
}

