/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.qa.findbugs;

import com.github.bordertech.wcomponents.qa.findbugs.Util;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.JavaClass;

public class CheckGetComponentModel
extends OpcodeStackDetector {
    private final Util util;

    public CheckGetComponentModel(BugReporter bugReporter) {
        this.util = new Util(bugReporter);
    }

    public boolean shouldVisit(JavaClass obj) {
        return this.util.isWComponent(obj);
    }

    public void sawOpcode(int seen) {
        String methodName = this.getMethodName();
        boolean setter = methodName.startsWith("set");
        boolean getter = methodName.startsWith("get");
        String bug = null;
        int priority = 2;
        switch (seen) {
            case 182: {
                OpcodeStack.Item model;
                XMethod from;
                if (this.util.isWComponent(this.getClassConstantOperand())) {
                    if (setter && "getComponentModel".equals(this.getNameConstantOperand()) && this.getSigConstantOperand().startsWith("()L")) {
                        bug = "WCGETM_INCORRECT_USE_OF_GETCOMPONENTMODEL";
                        break;
                    }
                    if (!getter || "getOrCreateComponentModel".equals(methodName) || !"getOrCreateComponentModel".equals(this.getNameConstantOperand()) || !this.getSigConstantOperand().startsWith("()L")) break;
                    bug = "WCGETM_INCORRECT_USE_OF_GETORCREATECOMPONENTMODEL";
                    break;
                }
                if (!this.util.isComponentModel(this.getClassConstantOperand()) || !this.getNameConstantOperand().startsWith("set") || (from = (model = this.stack.getStackItem(this.getNumberMethodArguments())).getReturnValueOf()) == null || !"getComponentModel".equals(from.getName()) || !from.getSignature().startsWith("()L") || !this.util.isWComponent(from.getClassName())) break;
                bug = "WCGETM_INCORRECT_USE_OF_GETCOMPONENTMODEL";
                priority = 1;
                break;
            }
            case 181: {
                OpcodeStack.Item model;
                XMethod from;
                if (!this.util.isComponentModel(this.getClassConstantOperand()) || !"getComponentModel".equals((from = (model = this.stack.getStackItem(1)).getReturnValueOf()).getName()) || !from.getSignature().startsWith("()L") || !this.util.isWComponent(from.getClassName())) break;
                bug = "WCGETM_INCORRECT_USE_OF_GETCOMPONENTMODEL";
                priority = 1;
            }
        }
        if (bug != null) {
            this.util.getBugReporter().reportBug(new BugInstance((Detector)this, bug, priority).addClass((PreorderVisitor)this).addMethod(MethodAnnotation.fromVisitedMethod((PreorderVisitor)this)).addSourceLine((BytecodeScanningDetector)this, this.getPC()));
        }
    }
}

