/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.qa.findbugs;

import com.github.bordertech.wcomponents.qa.findbugs.Util;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;

public class CheckWComponentFields
extends BytecodeScanningDetector {
    private final Util util;

    public CheckWComponentFields(BugReporter bugReporter) {
        this.util = new Util(bugReporter);
    }

    public boolean shouldVisit(JavaClass obj) {
        return this.util.isWComponent(obj);
    }

    public void visitField(Field obj) {
        FieldAnnotation ann;
        if (!obj.isFinal() && !obj.isStatic()) {
            ann = FieldAnnotation.fromVisitedField((PreorderVisitor)this);
            this.util.getBugReporter().reportBug(new BugInstance((Detector)this, "WCF_NON_FINAL_WCOMPONENT_FIELD", 1).addClass((PreorderVisitor)this).addField(ann));
        }
        if (this.util.isComponentModel(this.util.getClassNameFromSignature(obj.getType().getSignature()))) {
            ann = FieldAnnotation.fromVisitedField((PreorderVisitor)this);
            this.util.getBugReporter().reportBug(new BugInstance((Detector)this, "WCF_COMPONENT_MODEL_FIELD", 1).addClass((PreorderVisitor)this).addField(ann));
        }
        if (this.util.isUIContext(this.util.getClassNameFromSignature(obj.getType().getSignature()))) {
            ann = FieldAnnotation.fromVisitedField((PreorderVisitor)this);
            this.util.getBugReporter().reportBug(new BugInstance((Detector)this, "WCF_UICONTEXT_FIELD", 1).addClass((PreorderVisitor)this).addField(ann));
        }
    }
}

