/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.qa.findbugs;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DeepSubtypeAnalysis;
import org.apache.bcel.classfile.JavaClass;

public class Util {
    protected static final String WCOMPONENT_CLASS_NAME = "com.github.bordertech.wcomponents.WComponent";
    protected static final String COMPONENT_MODEL_CLASS_NAME = "com.github.bordertech.wcomponents.ComponentModel";
    protected static final String UICONTEXT_CLASS_NAME = "com.github.bordertech.wcomponents.UIContext";
    private final BugReporter bugReporter;

    public Util(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    protected boolean isWComponent(String className) {
        return this.isInstanceOf(className, WCOMPONENT_CLASS_NAME);
    }

    protected boolean isComponentModel(String className) {
        return this.isInstanceOf(className, COMPONENT_MODEL_CLASS_NAME);
    }

    protected boolean isUIContext(String className) {
        return this.isInstanceOf(className, UICONTEXT_CLASS_NAME);
    }

    private boolean isInstanceOf(String className, String instanceOfName) {
        double certainty = 0.0;
        try {
            certainty = DeepSubtypeAnalysis.deepInstanceOf((String)className, (String)instanceOfName);
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        return certainty == 1.0;
    }

    protected String getClassNameFromSignature(String sig) {
        if (sig != null && sig.length() > 2 && sig.charAt(0) == 'L' && sig.endsWith(";")) {
            return sig.substring(1, sig.length() - 1);
        }
        return sig;
    }

    public boolean isWComponent(JavaClass obj) {
        return this.isInstanceOf(obj, WCOMPONENT_CLASS_NAME);
    }

    public boolean isComponentModel(JavaClass obj) {
        return this.isInstanceOf(obj, COMPONENT_MODEL_CLASS_NAME);
    }

    private boolean isInstanceOf(JavaClass obj, String instanceOfName) {
        try {
            for (JavaClass interfaze : obj.getAllInterfaces()) {
                if (!instanceOfName.equals(interfaze.getClassName())) continue;
                return true;
            }
            for (JavaClass superClass : obj.getSuperClasses()) {
                if (!instanceOfName.equals(superClass.getClassName())) continue;
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        return false;
    }

    public BugReporter getBugReporter() {
        return this.bugReporter;
    }
}

