/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.lde;

import com.github.bordertech.wcomponents.UIContext;
import com.github.bordertech.wcomponents.UIContextHolder;
import com.github.bordertech.wcomponents.UIContextImpl;
import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.WText;
import com.github.bordertech.wcomponents.WebUtilities;
import com.github.bordertech.wcomponents.lde.DevToolkit;
import com.github.bordertech.wcomponents.util.Config;
import com.github.bordertech.wcomponents.util.mock.servlet.MockHttpServletRequest;
import com.github.bordertech.wcomponents.util.mock.servlet.MockHttpSession;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DevToolkit_Test {
    @Before
    public void setUp() {
        UIContextImpl uic = new UIContextImpl();
        uic.setUI((WComponent)new WText("dummy", new Serializable[0]));
        UIContextHolder.pushContext((UIContext)uic);
        Config.getInstance().setProperty("bordertech.wcomponents.lde.devToolkit.enabled", (Object)"true");
    }

    @After
    public void tearDown() {
        Config.reset();
        UIContextHolder.reset();
    }

    @Test
    public void testEnableDisableToolkit() {
        Config.getInstance().clearProperty("bordertech.wcomponents.lde.devToolkit.enabled");
        Assert.assertFalse((String)"DevToolkit should be disabled by default", (boolean)DevToolkit.isEnabled());
        Config.getInstance().setProperty("bordertech.wcomponents.lde.devToolkit.enabled", (Object)"false");
        Assert.assertFalse((String)"DevToolkit should be disabled", (boolean)DevToolkit.isEnabled());
        Config.getInstance().setProperty("bordertech.wcomponents.lde.devToolkit.enabled", (Object)"true");
        Assert.assertTrue((String)"DevToolkit should be enabled", (boolean)DevToolkit.isEnabled());
    }

    @Test
    public void testServiceRequest() {
        DevToolkit toolkit = new DevToolkit();
        Config.getInstance().clearProperty("bordertech.wcomponents.lde.devToolkit.enabled");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("wc_devToolkit", "x");
        request.setParameter("devToolkit_showTree", "true");
        toolkit.serviceRequest((HttpServletRequest)request);
        Assert.assertFalse((String)"Should have ignored the request when disabled", (boolean)toolkit.isShowTree());
        Config.getInstance().setProperty("bordertech.wcomponents.lde.devToolkit.enabled", (Object)"true");
        request = new MockHttpServletRequest();
        request.setParameter("wc_devToolkit", "x");
        request.setParameter("devToolkit_showTree", "true");
        toolkit.serviceRequest((HttpServletRequest)request);
        Assert.assertTrue((String)"Should have set show tree", (boolean)toolkit.isShowTree());
    }

    @Test
    public void testShowTree() {
        DevToolkit toolkit = new DevToolkit();
        Assert.assertFalse((String)"Should not show the tree by default", (boolean)toolkit.isShowTree());
        this.sendToolkitRequest(toolkit, "devToolkit_showTree", "true");
        Assert.assertTrue((String)"Should have set show tree to true", (boolean)toolkit.isShowTree());
        this.sendToolkitRequest(toolkit, "devToolkit_showTree", "false");
        Assert.assertFalse((String)"Should have set show tree to false", (boolean)toolkit.isShowTree());
    }

    @Test
    public void testShowConfig() {
        DevToolkit toolkit = new DevToolkit();
        Assert.assertFalse((String)"Should not show the configuration by default", (boolean)toolkit.isShowConfig());
        this.sendToolkitRequest(toolkit, "devToolkit_showConfig", "true");
        Assert.assertTrue((String)"Should have set show config to true", (boolean)toolkit.isShowConfig());
        this.sendToolkitRequest(toolkit, "devToolkit_showConfig", "false");
        Assert.assertFalse((String)"Should have set show config to false", (boolean)toolkit.isShowConfig());
    }

    @Test
    public void testShowUicStats() {
        DevToolkit toolkit = new DevToolkit();
        Assert.assertFalse((String)"Should not show the uic stats by default", (boolean)toolkit.isShowUicStats());
        this.sendToolkitRequest(toolkit, "devToolkit_showUicStats", "true");
        Assert.assertTrue((String)"Should have set show uic stats to true", (boolean)toolkit.isShowUicStats());
        this.sendToolkitRequest(toolkit, "devToolkit_showUicStats", "false");
        Assert.assertFalse((String)"Should have set show uic stats to false", (boolean)toolkit.isShowUicStats());
    }

    @Test
    public void testShowRequest() {
        DevToolkit toolkit = new DevToolkit();
        Assert.assertFalse((String)"Should not show the request by default", (boolean)toolkit.isShowRequest());
        this.sendToolkitRequest(toolkit, "devToolkit_showRequest", "true");
        Assert.assertTrue((String)"Should have set show request to true", (boolean)toolkit.isShowRequest());
        this.sendToolkitRequest(toolkit, "devToolkit_showRequest", "false");
        Assert.assertFalse((String)"Should have set show request to false", (boolean)toolkit.isShowRequest());
    }

    @Test
    public void testResetSession() {
        MockHttpSession session = new MockHttpSession();
        Assert.assertFalse((String)"Session should not be invalidated", (boolean)session.isInvalidated());
        DevToolkit toolkit = new DevToolkit();
        MockHttpServletRequest request = new MockHttpServletRequest((HttpSession)session);
        request.setParameter("wc_devToolkit", "x");
        toolkit.serviceRequest((HttpServletRequest)request);
        Assert.assertFalse((String)"Session should not be invalidated", (boolean)session.isInvalidated());
        request = new MockHttpServletRequest((HttpSession)session);
        request.setParameter("wc_devToolkit", "x");
        request.setParameter("devToolkit_resetSession", "x");
        toolkit.serviceRequest((HttpServletRequest)request);
        Assert.assertTrue((String)"Session should be invalidated", (boolean)session.isInvalidated());
    }

    @Test
    public void testPaintHeaderShowRequest() {
        DevToolkit toolkit = new DevToolkit();
        String header = this.renderHeader(toolkit);
        Assert.assertTrue((String)"Should not contain request info", (header.indexOf("request headers") == -1 ? 1 : 0) != 0);
        this.sendToolkitRequest(toolkit, "devToolkit_showRequest", "true");
        String paramKey1 = "DevToolkit_Test.testPaintHeaderShowRequest.pkey1";
        String paramKey2 = "DevToolkit_Test.testPaintHeaderShowRequest.pkey2";
        String paramValue1 = "DevToolkit_Test.testPaintHeaderShowRequest.pvalue1";
        String paramValue2 = "DevToolkit_Test.testPaintHeaderShowRequest.pvalue2";
        String headerKey1 = "DevToolkit_Test.testPaintHeaderShowRequest.hkey1";
        String headerKey2 = "DevToolkit_Test.testPaintHeaderShowRequest.hkey2";
        String headerValue1 = "DevToolkit_Test.testPaintHeaderShowRequest.hvalue1";
        String headerValue2 = "DevToolkit_Test.testPaintHeaderShowRequest.hvalue2";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("DevToolkit_Test.testPaintHeaderShowRequest.pkey1", "DevToolkit_Test.testPaintHeaderShowRequest.pvalue1");
        request.setParameter("DevToolkit_Test.testPaintHeaderShowRequest.pkey2", "DevToolkit_Test.testPaintHeaderShowRequest.pvalue2");
        request.setHeader("DevToolkit_Test.testPaintHeaderShowRequest.hkey1", "DevToolkit_Test.testPaintHeaderShowRequest.hvalue1");
        request.setHeader("DevToolkit_Test.testPaintHeaderShowRequest.hkey2", "DevToolkit_Test.testPaintHeaderShowRequest.hvalue2");
        toolkit.serviceRequest((HttpServletRequest)request);
        header = this.renderHeader(toolkit);
        Assert.assertTrue((String)"Should contain request info", (header.indexOf("request headers") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Output should contain parameter key1", (boolean)header.contains("DevToolkit_Test.testPaintHeaderShowRequest.pkey1"));
        Assert.assertTrue((String)"Output should contain parameter key2", (boolean)header.contains("DevToolkit_Test.testPaintHeaderShowRequest.pkey2"));
        Assert.assertTrue((String)"Output should contain parameter value1", (boolean)header.contains("DevToolkit_Test.testPaintHeaderShowRequest.pvalue1"));
        Assert.assertTrue((String)"Output should contain parameter value2", (boolean)header.contains("DevToolkit_Test.testPaintHeaderShowRequest.pvalue2"));
        Assert.assertTrue((String)"Output should contain header key1", (boolean)header.contains("DevToolkit_Test.testPaintHeaderShowRequest.hkey1"));
        Assert.assertTrue((String)"Output should contain header key2", (boolean)header.contains("DevToolkit_Test.testPaintHeaderShowRequest.hkey2"));
        Assert.assertTrue((String)"Output should contain header value1", (boolean)header.contains("DevToolkit_Test.testPaintHeaderShowRequest.hvalue1"));
        Assert.assertTrue((String)"Output should contain header value2", (boolean)header.contains("DevToolkit_Test.testPaintHeaderShowRequest.hvalue2"));
    }

    @Test
    public void testPaintHeaderShowConfig() {
        DevToolkit toolkit = new DevToolkit();
        String header = this.renderHeader(toolkit);
        Assert.assertTrue((String)"Should not contain config", (header.indexOf("WComponent configuration") == -1 ? 1 : 0) != 0);
        this.sendToolkitRequest(toolkit, "devToolkit_showConfig", "true");
        header = this.renderHeader(toolkit);
        Assert.assertTrue((String)"Should contain config", (header.indexOf("WComponent configuration") != -1 ? 1 : 0) != 0);
        Iterator i = Config.getInstance().getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = Config.getInstance().getString(key);
            Assert.assertTrue((String)("Should contain key " + key), (header.indexOf(WebUtilities.encode((String)key)) != -1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Should contain value " + value), (header.indexOf(WebUtilities.encode((String)value)) != -1 ? 1 : 0) != 0);
        }
    }

    private void sendToolkitRequest(DevToolkit toolkit, String key, String value) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("wc_devToolkit", "x");
        request.setParameter(key, value);
        toolkit.serviceRequest((HttpServletRequest)request);
    }

    private String renderHeader(DevToolkit toolkit) {
        StringWriter buf = new StringWriter();
        PrintWriter writer = new PrintWriter(buf);
        toolkit.paintHeader(writer);
        writer.close();
        return buf.toString();
    }
}

