/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.lde;

import com.github.bordertech.wcomponents.lde.LdeSessionUtil;
import com.github.bordertech.wcomponents.util.mock.servlet.MockHttpSession;
import javax.servlet.http.HttpSession;
import junit.framework.Assert;
import org.junit.Test;

public class LdeSessionUtil_Test {
    private static final String STRING_KEY = "LdeSessionUtil_Test.stringKey";
    private static final String STRING_VALUE = "LdeSessionUtil_Test.stringValue";
    private static final String INT_KEY = "LdeSessionUtil_Test.intKey";
    private static final Integer INT_VALUE = new Integer(123456);
    private static final String NON_SERIALIZABLE_KEY = "LdeSessionUtil_Test.nonSerializableKey";
    private static final NonSerializable NON_SERIALIZABLE_VALUE = new NonSerializable();

    @Test
    public void testSessionSerialization() {
        MockHttpSession session1 = new MockHttpSession();
        MockHttpSession session2 = new MockHttpSession();
        session1.setAttribute(STRING_KEY, (Object)STRING_VALUE);
        session1.setAttribute(INT_KEY, (Object)INT_VALUE);
        session1.setAttribute(NON_SERIALIZABLE_KEY, (Object)NON_SERIALIZABLE_VALUE);
        LdeSessionUtil.serializeSessionAttributes((HttpSession)session1);
        LdeSessionUtil.deserializeSessionAttributes((HttpSession)session2);
        Assert.assertEquals((String)"Incorrect number of deserialized session attribute", (int)2, (int)session2.getAttributes().size());
        Assert.assertEquals((String)"Incorrect value of String attribute", (Object)STRING_VALUE, (Object)session2.getAttribute(STRING_KEY));
        Assert.assertEquals((String)"Incorrect value of Integer attribute", (Object)INT_VALUE, (Object)session2.getAttribute(INT_KEY));
        Assert.assertFalse((String)"Session should not contain", (boolean)session2.getAttributes().containsKey(NON_SERIALIZABLE_KEY));
    }

    private static final class NonSerializable {
        private NonSerializable() {
        }
    }
}

