/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.lde;

import com.github.bordertech.wcomponents.AbstractWComponent;
import com.github.bordertech.wcomponents.Environment;
import com.github.bordertech.wcomponents.RenderContext;
import com.github.bordertech.wcomponents.Request;
import com.github.bordertech.wcomponents.UIContext;
import com.github.bordertech.wcomponents.UIContextHolder;
import com.github.bordertech.wcomponents.UIContextImpl;
import com.github.bordertech.wcomponents.WApplication;
import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.WText;
import com.github.bordertech.wcomponents.WebUtilities;
import com.github.bordertech.wcomponents.lde.PlainLauncher;
import com.github.bordertech.wcomponents.servlet.WServlet;
import com.github.bordertech.wcomponents.util.Config;
import com.github.bordertech.wcomponents.util.StreamUtil;
import com.github.bordertech.wcomponents.util.mock.servlet.MockHttpServletRequest;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Test;

public class PlainLauncher_Test {
    private PlainLauncher launcher;

    @After
    public void tearDown() throws InterruptedException {
        Config.reset();
        UIContextHolder.reset();
        if (this.launcher != null) {
            this.launcher.stop();
            this.launcher = null;
        }
    }

    @Test
    public void testCreateUI() {
        Config.getInstance().clearProperty("bordertech.wcomponents.lde.component.to.launch");
        this.launcher = new PlainLauncher();
        WComponent ui = this.launcher.createUI();
        Assert.assertTrue((String)"UI should be an instance of WText", (boolean)(ui instanceof WText));
        Assert.assertTrue((String)"UI should contain instructions on configuring the LDE", (boolean)((WText)ui).getText().contains("bordertech.wcomponents.lde.component.to.launch"));
    }

    @Test
    public void testGetUI() {
        Config.getInstance().setProperty("bordertech.wcomponents.lde.component.to.launch", (Object)MyTestApp.class.getName());
        this.launcher = new PlainLauncher();
        WComponent ui1 = this.launcher.getUI((Object)new MockHttpServletRequest());
        Assert.assertTrue((String)"UI should be an instance of MyTestComponent", (boolean)(ui1 instanceof MyTestApp));
        WComponent ui2 = this.launcher.getUI((Object)new MockHttpServletRequest());
        Assert.assertSame((String)"Should have returned the same UI instance", (Object)ui1, (Object)ui2);
    }

    @Test
    public void testGetUINonWApplication() {
        Config.getInstance().setProperty("bordertech.wcomponents.lde.component.to.launch", (Object)MyTestComponent.class.getName());
        PlainLauncher plain = new PlainLauncher();
        WComponent ui1 = plain.getUI((Object)new MockHttpServletRequest());
        Assert.assertTrue((String)"Root UI should be a WApplication", (boolean)(ui1 instanceof WApplication));
        ui1 = ((WApplication)ui1).getChildAt(0);
        Assert.assertTrue((String)"UI should be an instance of MyTestComponent", (boolean)(ui1 instanceof MyTestComponent));
        WComponent ui2 = ((WApplication)plain.getUI((Object)new MockHttpServletRequest())).getChildAt(0);
        Assert.assertSame((String)"Should have returned the same UI instance", (Object)ui1, (Object)ui2);
    }

    @Test
    public void testServer() throws Exception {
        Config.getInstance().setProperty("bordertech.wcomponents.lde.component.to.launch", (Object)MyTestApp.class.getName());
        Config.getInstance().setProperty("bordertech.wcomponents.lde.server.port", (Object)"0");
        Config.getInstance().setProperty("bordertech.wcomponents.whitespaceFilter.enabled", (Object)"false");
        this.launcher = new PlainLauncher();
        this.launcher.run();
        URL url = new URL(this.launcher.getUrl());
        URLConnection conn = url.openConnection();
        byte[] result = StreamUtil.getBytes((InputStream)conn.getInputStream());
        String content = new String(result, "UTF-8");
        Assert.assertEquals((String)"HandleRequest should have been called once", (int)1, (int)MyTestApp.handleRequestCount);
        Assert.assertEquals((String)"PaintComponent should have been called once", (int)1, (int)MyTestApp.paintCount);
        String tokenSearch = "\"wc_t\" value=\"";
        int start = content.indexOf(tokenSearch);
        int end = content.indexOf("\"", start + tokenSearch.length());
        String token = content.substring(start + tokenSearch.length(), end);
        UIContextImpl uic = new UIContextImpl();
        WServlet.WServletEnvironment env = new WServlet.WServletEnvironment(url.getPath(), url.toString(), "");
        env.setStep(1);
        env.setSessionToken(token);
        uic.setEnvironment((Environment)env);
        UIContextHolder.pushContext((UIContext)uic);
        String expected = WebUtilities.render((WComponent)new MyTestApp());
        Assert.assertTrue((String)"Content should contain the rendered application", (boolean)content.contains(expected));
    }

    public static final class MyTestApp
    extends WApplication {
        private static final String HELLO_WORLD = "Hello world!";
        private static int handleRequestCount = 0;
        private static int paintCount = 0;

        public MyTestApp() {
            this.add((WComponent)new WText(HELLO_WORLD, new Serializable[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRequest(Request request) {
            super.handleRequest(request);
            Class<MyTestApp> clazz = MyTestApp.class;
            synchronized (MyTestApp.class) {
                ++handleRequestCount;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintComponent(RenderContext renderContext) {
            super.paintComponent(renderContext);
            Class<MyTestApp> clazz = MyTestApp.class;
            synchronized (MyTestApp.class) {
                ++paintCount;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    public static final class MyTestComponent
    extends AbstractWComponent {
    }
}

