/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.lde;

import com.github.bordertech.wcomponents.util.ConfigurationProperties;
import com.github.bordertech.wcomponents.util.StreamUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LdeSessionUtil {
    private static final String SERIALIZE_SESSION_NAME = "lde_session.dat";
    private static final Log LOG = LogFactory.getLog(LdeSessionUtil.class);

    private LdeSessionUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deserializeSessionAttributes(HttpSession session) {
        block9: {
            File file;
            block10: {
                FileInputStream fis;
                block7: {
                    file = new File(SERIALIZE_SESSION_NAME);
                    fis = null;
                    ObjectInputStream ois = null;
                    if (!file.canRead()) break block10;
                    try {
                        fis = new FileInputStream(file);
                        ois = new ObjectInputStream(fis);
                        List data = (List)ois.readObject();
                        Iterator i = data.iterator();
                        while (i.hasNext()) {
                            String key = (String)i.next();
                            Object value = i.next();
                            session.setAttribute(key, value);
                        }
                        if (ois == null) break block7;
                    }
                    catch (Exception e) {
                        block8: {
                            try {
                                LOG.error((Object)("Failed to read serialized session from " + file), (Throwable)e);
                                if (ois == null) break block8;
                            }
                            catch (Throwable throwable) {
                                if (ois != null) {
                                    StreamUtil.safeClose(ois);
                                } else {
                                    StreamUtil.safeClose((Closeable)fis);
                                }
                                throw throwable;
                            }
                            StreamUtil.safeClose((Closeable)ois);
                            break block9;
                        }
                        StreamUtil.safeClose((Closeable)fis);
                        break block9;
                    }
                    StreamUtil.safeClose((Closeable)ois);
                    break block9;
                }
                StreamUtil.safeClose((Closeable)fis);
                break block9;
            }
            LOG.warn((Object)("Unable to read serialized session from " + file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void serializeSessionAttributes(HttpSession session) {
        block10: {
            File file;
            block11: {
                FileOutputStream fos;
                block8: {
                    if (session == null) break block10;
                    file = new File(SERIALIZE_SESSION_NAME);
                    if (file.exists() && !file.canWrite()) break block11;
                    ArrayList<Object> data = new ArrayList<Object>();
                    Enumeration keyEnum = session.getAttributeNames();
                    while (keyEnum.hasMoreElements()) {
                        String attributeName = (String)keyEnum.nextElement();
                        Object attributeValue = session.getAttribute(attributeName);
                        if (attributeValue instanceof Serializable) {
                            data.add(attributeName);
                            data.add(attributeValue);
                            continue;
                        }
                        LOG.error((Object)("Skipping attribute \"" + attributeName + "\" as it is not Serializable"));
                    }
                    fos = null;
                    ObjectOutputStream oos = null;
                    try {
                        fos = new FileOutputStream(file);
                        oos = new ObjectOutputStream(fos);
                        oos.writeObject(data);
                        if (oos == null) break block8;
                    }
                    catch (Exception e) {
                        block9: {
                            try {
                                LOG.error((Object)("Failed to write serialized session to " + file), (Throwable)e);
                                if (oos == null) break block9;
                            }
                            catch (Throwable throwable) {
                                if (oos != null) {
                                    StreamUtil.safeClose(oos);
                                } else {
                                    StreamUtil.safeClose((Closeable)fos);
                                }
                                throw throwable;
                            }
                            StreamUtil.safeClose((Closeable)oos);
                            break block10;
                        }
                        StreamUtil.safeClose((Closeable)fos);
                        break block10;
                    }
                    StreamUtil.safeClose((Closeable)oos);
                    break block10;
                }
                StreamUtil.safeClose((Closeable)fos);
                break block10;
            }
            LOG.warn((Object)("Unable to write serialized session to " + file));
        }
    }

    public static boolean isLoadPersistedSessionEnabled() {
        return ConfigurationProperties.getLdeLoadPersistedSessionEnabled();
    }

    public static boolean isPersistSessionEnabled() {
        return ConfigurationProperties.getLdePersistSessionEnabled();
    }
}

