/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.lde;

import com.github.bordertech.wcomponents.WApplication;
import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.WText;
import com.github.bordertech.wcomponents.lde.TestServlet;
import com.github.bordertech.wcomponents.monitor.ProfileContainer;
import com.github.bordertech.wcomponents.registry.UIRegistry;
import com.github.bordertech.wcomponents.util.ConfigurationProperties;
import com.github.bordertech.wcomponents.util.Util;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlainLauncher
extends TestServlet {
    private static final Log LOG = LogFactory.getLog(PlainLauncher.class);
    public static final String COMPONENT_TO_LAUNCH_PARAM_KEY = "bordertech.wcomponents.lde.component.to.launch";
    protected static final String SHOW_MEMORY_PROFILE_PARAM_KEY = "bordertech.wcomponents.lde.show.memory.profile";
    private WApplication sharedUI;
    private String uiClassName;

    public synchronized WComponent getUI(Object httpServletRequest) {
        String configuredUIClassName = this.getComponentToLaunchClassName();
        if (this.sharedUI == null || !Util.equals((Object)configuredUIClassName, (Object)this.uiClassName)) {
            this.uiClassName = configuredUIClassName;
            WComponent ui = this.createUI();
            if (ui instanceof WApplication) {
                this.sharedUI = (WApplication)ui;
            } else {
                LOG.warn((Object)"Top-level component should be a WApplication. Creating WApplication wrapper...");
                this.sharedUI = new WApplication();
                ui.setLocked(false);
                this.sharedUI.add(ui);
                this.sharedUI.setLocked(true);
            }
            if (ConfigurationProperties.getLdeServerShowMemoryProfile()) {
                ProfileContainer profiler = new ProfileContainer();
                this.sharedUI.setLocked(false);
                this.sharedUI.add((WComponent)profiler);
                this.sharedUI.setLocked(true);
            }
        }
        return this.sharedUI;
    }

    protected WComponent createUI() {
        WText sharedApp;
        this.uiClassName = this.getComponentToLaunchClassName();
        if (this.uiClassName == null) {
            sharedApp = new WText("You need to set the class name of the WComponent you want to run.<br />Do this by setting the parameter \"bordertech.wcomponents.lde.component.to.launch\" in your \"local_app.properties\" file.<br />Eg.  <code>bordertech.wcomponents.lde.component.to.launch=com.github.bordertech.wcomponents.examples.picker.ExamplePicker</code>", new Serializable[0]);
            sharedApp.setEncodeText(false);
        } else {
            UIRegistry registry = UIRegistry.getInstance();
            sharedApp = registry.getUI(this.uiClassName);
            if (sharedApp == null) {
                sharedApp = new WText("Unable to load the component \"" + this.uiClassName + "\".<br />" + "Either the component does not exist as a resource in the classpath," + " or is not a WComponent.<br />" + "Check that the parameter \"" + COMPONENT_TO_LAUNCH_PARAM_KEY + "\" is set correctly.", new Serializable[0]);
                sharedApp.setEncodeText(false);
            }
        }
        return sharedApp;
    }

    protected String getComponentToLaunchClassName() {
        return ConfigurationProperties.getLdePlainLauncherComponentToLaunch();
    }

    public static void main(String[] args) throws Exception {
        PlainLauncher launcher = new PlainLauncher();
        launcher.run();
    }
}

