/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.lde;

import com.github.bordertech.wcomponents.UIContext;
import com.github.bordertech.wcomponents.UIContextHolder;
import com.github.bordertech.wcomponents.WebUtilities;
import com.github.bordertech.wcomponents.monitor.UicStats;
import com.github.bordertech.wcomponents.monitor.UicStatsAsHtml;
import com.github.bordertech.wcomponents.util.AbstractTreeNode;
import com.github.bordertech.wcomponents.util.Config;
import com.github.bordertech.wcomponents.util.ConfigurationProperties;
import com.github.bordertech.wcomponents.util.TreeNode;
import com.github.bordertech.wcomponents.velocity.VelocityEngineFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

@Deprecated
public final class DevToolkit {
    private static final Log LOG = LogFactory.getLog(DevToolkit.class);
    private boolean showTree = false;
    private boolean showConfig = false;
    private boolean showUicStats = false;
    private boolean showRequest = false;
    private boolean showIds = false;
    private String[][] requestParameters;
    private String[][] requestHeaders;
    private String requestMethod;

    public static boolean isEnabled() {
        return ConfigurationProperties.getDeveloperToolkit();
    }

    protected void serviceRequest(HttpServletRequest request) {
        HttpSession session;
        this.requestParameters = null;
        this.requestHeaders = null;
        if (!DevToolkit.isEnabled()) {
            return;
        }
        if (request.getParameter("wc_devToolkit") == null) {
            if (this.showRequest) {
                this.requestParameters = this.getRequestParameters(request);
                this.requestHeaders = this.getRequestHeaders(request);
                this.requestMethod = request.getMethod();
            }
            return;
        }
        this.showTree = "true".equals(request.getParameter("devToolkit_showTree"));
        this.showConfig = "true".equals(request.getParameter("devToolkit_showConfig"));
        this.showUicStats = "true".equals(request.getParameter("devToolkit_showUicStats"));
        this.showRequest = "true".equals(request.getParameter("devToolkit_showRequest"));
        this.showIds = "true".equals(request.getParameter("devToolkit_showIds"));
        boolean whitespaceEnabled = "true".equals(request.getParameter("devToolkit_whitespaceFilterEnabled"));
        Config.getInstance().setProperty("bordertech.wcomponents.whitespaceFilter.enabled", (Object)whitespaceEnabled);
        if (request.getParameter("devToolkit_resetSession") != null && (session = request.getSession(false)) != null) {
            session.invalidate();
        }
        if (request.getParameter("devToolkit_rootComponentSelect") != null) {
            Config.getInstance().setProperty("bordertech.wcomponents.lde.component.to.launch", (Object)request.getParameter("devToolkit_rootComponent"));
        }
        boolean debug = "true".equals(request.getParameter("devToolkit_debugEnabled"));
        Config.getInstance().setProperty("bordertech.wcomponents.debug.enabled", (Object)debug);
        Config.notifyListeners();
    }

    public String[][] getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    private String[][] getRequestHeaders(HttpServletRequest request) {
        ArrayList<String> headerKeys = new ArrayList<String>();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            headerKeys.add((String)e.nextElement());
        }
        Collections.sort(headerKeys);
        String[][] headers = new String[headerKeys.size()][2];
        for (int i = 0; i < headers.length; ++i) {
            headers[i][0] = (String)headerKeys.get(i);
            headers[i][1] = request.getHeader(headers[i][0]);
        }
        return headers;
    }

    public String[][] getRequestParameters() {
        return this.requestParameters;
    }

    private String[][] getRequestParameters(HttpServletRequest request) {
        ArrayList<String> paramKeys = new ArrayList<String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            paramKeys.add((String)e.nextElement());
        }
        Collections.sort(paramKeys);
        String[][] params = new String[paramKeys.size()][2];
        for (int i = 0; i < params.length; ++i) {
            params[i][0] = (String)paramKeys.get(i);
            params[i][1] = request.getParameter(params[i][0]);
        }
        return params;
    }

    public TreeNode getTree() {
        UITreeNode root;
        UIContext uic = UIContextHolder.getCurrentPrimaryUIContext();
        String[] debugTree = uic.getUI().toString().split("\n");
        UITreeNode parent = root = new UITreeNode(debugTree[0]);
        UITreeNode last = root;
        for (int i = 1; i < debugTree.length; ++i) {
            UITreeNode child;
            String line = debugTree[i].trim();
            if (line.charAt(0) == '[') {
                parent = last;
                child = new UITreeNode(debugTree[++i]);
                parent.add((TreeNode)child);
                last = child;
                continue;
            }
            if (line.charAt(0) == ']') {
                parent = parent.getParent();
                continue;
            }
            child = new UITreeNode(debugTree[i]);
            parent.add((TreeNode)child);
            last = child;
        }
        return root;
    }

    public String getUicStats() {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        UicStats stats = new UicStats(UIContextHolder.getCurrent());
        UicStatsAsHtml.write((PrintWriter)printWriter, (UicStats)stats);
        printWriter.close();
        return writer.toString();
    }

    public boolean isShowTree() {
        return this.showTree;
    }

    public boolean isShowConfig() {
        return this.showConfig;
    }

    public boolean isShowUicStats() {
        return this.showUicStats;
    }

    public boolean isShowRequest() {
        return this.showRequest;
    }

    public boolean isWhitespaceFilterEnabled() {
        return ConfigurationProperties.getWhitespaceFilter();
    }

    public boolean isShowIds() {
        return this.showIds;
    }

    public String getRootComponent() {
        return Config.getInstance().getString("bordertech.wcomponents.lde.component.to.launch");
    }

    public boolean isDebugEnabled() {
        return ConfigurationProperties.getDeveloperDebugEnabled();
    }

    public String[][] getConfig() {
        ArrayList<String> keys = new ArrayList<String>();
        Configuration config = Config.getInstance();
        Iterator i = config.getKeys();
        while (i.hasNext()) {
            keys.add((String)i.next());
        }
        Collections.sort(keys);
        String[][] configTable = new String[keys.size()][2];
        for (int i2 = 0; i2 < keys.size(); ++i2) {
            configTable[i2][0] = (String)keys.get(i2);
            configTable[i2][1] = config.getString(configTable[i2][0]);
        }
        return configTable;
    }

    public String encode(String input) {
        return WebUtilities.encode((String)input);
    }

    public void paintHeader(PrintWriter writer) {
        this.paint("com/github/bordertech/wcomponents/lde/DevToolkit_header.vm", writer);
    }

    public void paintFooter(PrintWriter writer) {
        this.paint("com/github/bordertech/wcomponents/lde/DevToolkit_footer.vm", writer);
    }

    private void paint(String templateName, PrintWriter writer) {
        if (!DevToolkit.isEnabled()) {
            return;
        }
        try {
            Template template = VelocityEngineFactory.getVelocityEngine().getTemplate(templateName);
            VelocityContext context = new VelocityContext();
            context.put("this", (Object)this);
            UIContext uic = UIContextHolder.getCurrentPrimaryUIContext();
            context.put("uic", (Object)uic);
            context.put("ui", (Object)uic.getUI());
            template.merge((Context)context, (Writer)writer);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to render dev toolkit", (Throwable)e);
        }
    }

    public static final class UITreeNode
    extends AbstractTreeNode {
        private final String text;

        public UITreeNode(String text) {
            this.text = text.charAt(text.length() - 1) == ',' ? text.substring(0, text.length() - 1).trim() : text.trim();
        }

        public String toString() {
            return WebUtilities.encode((String)this.text);
        }

        public TreeNode[] getChildren() {
            TreeNode[] children = new TreeNode[this.getChildCount()];
            for (int i = 0; i < children.length; ++i) {
                children[i] = this.getChildAt(i);
            }
            return children;
        }
    }
}

