/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.lde;

import com.github.bordertech.wcomponents.lde.LdeLauncher;
import com.github.bordertech.wcomponents.lde.LdeSessionUtil;
import com.github.bordertech.wcomponents.servlet.WServlet;
import com.github.bordertech.wcomponents.util.ConfigurationProperties;
import com.github.bordertech.wcomponents.util.SystemException;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.WebAppContext;

public abstract class TestServlet
extends WServlet
implements LdeLauncher {
    private static final Log LOG = LogFactory.getLog(TestServlet.class);
    private final List<Resource> union = new ArrayList<Resource>();
    private static Server server;
    private String url;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        Class<TestServlet> clazz = TestServlet.class;
        synchronized (TestServlet.class) {
            if (server != null) {
                this.stop();
            }
            server = new Server();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            SocketConnector connector = new SocketConnector();
            connector.setMaxIdleTime(0);
            connector.setPort(TestServlet.getLdePort());
            server.addConnector((Connector)connector);
            WebAppContext webapp = this.createWebApp(server);
            try {
                server.start();
            }
            catch (BindException e) {
                if (this.isShutdownEnabled()) {
                    LOG.info((Object)"Attempting remote shutdown of existing LDE");
                    this.shutDown();
                    Thread.sleep(100L);
                    server.start();
                }
                throw e;
            }
            catch (Exception e) {
                server = null;
                throw e;
            }
            int timeout = ConfigurationProperties.getLdeServerSessionTimeout();
            if (timeout > 0) {
                webapp.getSessionHandler().getSessionManager().setMaxInactiveInterval(timeout);
            }
            this.url = "http://localhost:" + connector.getLocalPort() + "/app";
            LOG.info((Object)("URL  ==>  " + this.url));
            return;
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (req.getParameter("lde.shutdown") != null && this.isShutdownEnabled()) {
            LOG.info((Object)"Received LDE shutdown request, stopping server.");
            res.getOutputStream().close();
            try {
                this.stop();
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Failed to shut down LDE server", (Throwable)e);
            }
            return;
        }
        super.service(req, res);
    }

    private static int getLdePort() {
        return ConfigurationProperties.getLdeServerPort();
    }

    protected void shutDown() {
        try {
            URL shutdownUrl = new URL("http://localhost:" + TestServlet.getLdePort() + "/app?lde.shutdown=true");
            HttpURLConnection conn = (HttpURLConnection)shutdownUrl.openConnection();
            conn.getResponseCode();
        }
        catch (ConnectException expected) {
            return;
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to shut down other LDE instance", (Throwable)e);
        }
    }

    protected WebAppContext createWebApp(Server srv) throws Exception {
        WebAppContext themeWebapp;
        int i;
        String[] webdocs = this.getWebdocsDir();
        String[] themeWebdocs = this.getThemeWebdocs();
        String[] resourceDirs = this.getResourceDir();
        if (webdocs != null) {
            for (i = 0; i < webdocs.length; ++i) {
                this.union.add(Resource.newResource((String)webdocs[i]));
            }
        }
        if (themeWebdocs != null) {
            for (i = 0; i < themeWebdocs.length; ++i) {
                this.union.add(Resource.newResource((String)themeWebdocs[i]));
            }
        }
        if (resourceDirs != null) {
            for (i = 0; i < resourceDirs.length; ++i) {
                this.union.add(Resource.newResource((String)resourceDirs[i]));
            }
        }
        HandlerCollection handlers = new HandlerCollection();
        WebAppContext webapp = null;
        if (webdocs == null) {
            webapp = new WebAppContext();
            webapp.setContextPath("/");
            this.registerServlets(webapp);
        } else {
            webapp = new WebAppContext(webdocs[0], "/");
        }
        if (this.union.isEmpty()) {
            webapp.setResourceBase(".");
        } else {
            webapp.setBaseResource((Resource)new ResourceCollection(this.union.toArray(new Resource[this.union.size()])));
        }
        webapp.addServlet(new ServletHolder((Servlet)this), "/app/*");
        if (themeWebdocs == null) {
            themeWebapp = new WebAppContext();
            themeWebapp.setContextPath("/theme");
            themeWebapp.addServlet("com.github.bordertech.wcomponents.servlet.ThemeServlet", "/*");
            themeWebapp.setResourceBase(".");
            handlers.addHandler((Handler)themeWebapp);
        } else {
            themeWebapp = new WebAppContext();
            themeWebapp.setContextPath("/theme");
            themeWebapp.setResourceBase(themeWebdocs[0]);
            handlers.addHandler((Handler)themeWebapp);
        }
        String realmFile = ConfigurationProperties.getLdeServerJettyRealmFile();
        if (realmFile != null) {
            HashLoginService loginService = new HashLoginService("LdeRunner", realmFile);
            webapp.getSecurityHandler().setLoginService((LoginService)loginService);
        }
        handlers.addHandler((Handler)webapp);
        srv.setHandler((Handler)handlers);
        return webapp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws InterruptedException {
        Class<TestServlet> clazz = TestServlet.class;
        synchronized (TestServlet.class) {
            if (server != null) {
                try {
                    server.stop();
                }
                catch (Exception e) {
                    LOG.warn((Object)"Failed to stop server", (Throwable)e);
                }
                server = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean isRunning() {
        return server != null && server.isRunning();
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void addIndirectJar(String jarname) {
        try (JarFile jarfile = new JarFile(jarname);){
            Manifest man = jarfile.getManifest();
            Attributes atts = man.getMainAttributes();
            String jarlist = atts.getValue("Class-Path");
            StringTokenizer tokenizer = new StringTokenizer(jarlist, " ", false);
            while (tokenizer.hasMoreTokens()) {
                String tokenUrl = tokenizer.nextToken();
                this.union.add(Resource.newResource((String)("jar:" + tokenUrl + "!/")));
                LOG.info((Object)("Added webdocs at " + tokenUrl));
            }
        }
        catch (IOException ex) {
            throw new SystemException("Could handle indirect jar " + jarname, (Throwable)ex);
        }
    }

    protected String[] getWebdocsDir() {
        String[] docs = ConfigurationProperties.getLdeServerWebDocsDir();
        return docs == null || docs.length == 0 ? null : docs;
    }

    protected String[] getThemeWebdocs() {
        String[] docs = ConfigurationProperties.getLdeServerWebDocsThemeDir();
        return docs == null || docs.length == 0 ? null : docs;
    }

    protected String[] getResourceDir() {
        String[] docs = ConfigurationProperties.getLdeServerWebDocsResourcesDir();
        return docs == null || docs.length == 0 ? null : docs;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getSession(false) == null && LdeSessionUtil.isLoadPersistedSessionEnabled()) {
            this.getUI(request);
            LdeSessionUtil.deserializeSessionAttributes(request.getSession(true));
        }
        super.service(request, response);
        if (LdeSessionUtil.isPersistSessionEnabled()) {
            LdeSessionUtil.serializeSessionAttributes(request.getSession());
        }
    }

    protected void registerServlets(WebAppContext webapp) {
    }

    protected boolean isShutdownEnabled() {
        return ConfigurationProperties.getLdeServerEnableShutdown();
    }
}

