/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.lde;

import com.github.bordertech.wcomponents.lde.PlainLauncher;
import com.github.bordertech.wcomponents.util.Config;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StandaloneLauncher {
    private static final StandaloneLauncher INSTANCE = new StandaloneLauncher();
    private final MyLauncher launcher = new MyLauncher();
    private final JTextArea log = new JTextArea();

    private StandaloneLauncher() {
        final JFrame frame = new JFrame("WComponent stand-alone LDE");
        frame.setDefaultCloseOperation(3);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        frame.setContentPane(content);
        content.add((Component)new JLabel("Log:"), "North");
        this.log.setColumns(120);
        this.log.setRows(30);
        this.log.setFont(new Font("Monospaced", 0, 12));
        content.add((Component)new JScrollPane(this.log, 22, 30), "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0, 5, 0));
        content.add((Component)buttonPanel, "South");
        JButton button = new JButton("Clear log");
        buttonPanel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StandaloneLauncher.this.log.setText("");
            }
        });
        button = new JButton("Launch browser");
        buttonPanel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Class<?> clazz = Class.forName("java.awt.Desktop");
                    Object instance = clazz.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    clazz.getMethod("browse", URI.class).invoke(instance, new URI(StandaloneLauncher.getInstance().launcher.getUrl()));
                }
                catch (ClassNotFoundException e) {
                    String cmd = "rundll32 url.dll,FileProtocolHandler " + StandaloneLauncher.getInstance().launcher.getUrl();
                    try {
                        Runtime.getRuntime().exec(cmd);
                    }
                    catch (Exception e2) {
                        LogFactory.getLog(this.getClass()).error((Object)"Failed to launch browser", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    LogFactory.getLog(this.getClass()).error((Object)"Failed to launch browser", (Throwable)e);
                }
            }
        });
        button = new JButton("Exit");
        buttonPanel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                WindowEvent closeEvent = new WindowEvent(frame, 201);
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(closeEvent);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    public static StandaloneLauncher getInstance() {
        return INSTANCE;
    }

    public void log(final String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StandaloneLauncher.this.log(message);
                }
            });
        } else {
            this.log.append(message);
        }
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("org.apache.commons.logging.Log", "com.github.bordertech.wcomponents.lde.StandaloneLauncher$TextAreaLogger");
        Configuration internalWComponentConfig = Config.getInstance();
        CompositeConfiguration config = new CompositeConfiguration((Configuration)new MapConfiguration(new HashMap()));
        config.addConfiguration(internalWComponentConfig);
        config.setProperty("bordertech.wcomponents.lde.server.port", (Object)0);
        Config.setConfiguration((Configuration)config);
        StandaloneLauncher.getInstance().launcher.run();
        StandaloneLauncher.getInstance().log("LDE now running on " + StandaloneLauncher.getInstance().launcher.getUrl() + '\n');
    }

    public static final class TextAreaLogger
    implements Log {
        public static final int TRACE = 0;
        public static final int DEBUG = 1;
        public static final int INFO = 2;
        public static final int WARN = 3;
        public static final int ERROR = 4;
        public static final int FATAL = 5;
        private int logLevel = 1;

        public TextAreaLogger(String name) {
        }

        public void setLogLevel(int level) {
            this.logLevel = level;
        }

        private void log(Object message, Throwable throwable, int level) {
            if (level < this.logLevel) {
                return;
            }
            if (message != null) {
                String prefix = new SimpleDateFormat("dd/MM/yy HH:mm:ss").format(new Date()) + ": ";
                StandaloneLauncher.getInstance().log(prefix + message.toString() + '\n');
            }
            if (throwable != null) {
                StringWriter writer = new StringWriter();
                PrintWriter printWriter = new PrintWriter(writer);
                throwable.printStackTrace(printWriter);
                printWriter.close();
                StandaloneLauncher.getInstance().log(writer.toString());
            }
        }

        public void debug(Object message, Throwable cause) {
            this.log(message, cause, 1);
        }

        public void debug(Object message) {
            this.log(message, null, 1);
        }

        public void error(Object message, Throwable cause) {
            this.log(message, cause, 4);
        }

        public void error(Object message) {
            this.log(message, null, 4);
        }

        public void fatal(Object message, Throwable cause) {
            this.log(message, cause, 5);
        }

        public void fatal(Object message) {
            this.log(message, null, 5);
        }

        public void info(Object message, Throwable cause) {
            this.log(message, cause, 2);
        }

        public void info(Object message) {
            this.log(message, null, 2);
        }

        public void warn(Object message, Throwable cause) {
            this.log(message, cause, 3);
        }

        public void warn(Object message) {
            this.log(message, null, 3);
        }

        public boolean isDebugEnabled() {
            return this.logLevel <= 1;
        }

        public boolean isErrorEnabled() {
            return this.logLevel <= 4;
        }

        public boolean isFatalEnabled() {
            return this.logLevel <= 5;
        }

        public boolean isInfoEnabled() {
            return this.logLevel <= 2;
        }

        public boolean isWarnEnabled() {
            return this.logLevel <= 3;
        }

        public boolean isTraceEnabled() {
            return this.logLevel <= 0;
        }

        public void trace(Object message, Throwable cause) {
            this.log(message, cause, 0);
        }

        public void trace(Object message) {
            this.log(message, null, 0);
        }
    }

    public static final class MyLauncher
    extends PlainLauncher {
        @Override
        public String getUrl() {
            return super.getUrl();
        }
    }
}

