/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.example;

import com.github.bordertech.wcomponents.Action;
import com.github.bordertech.wcomponents.ActionEvent;
import com.github.bordertech.wcomponents.WButton;
import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.WContainer;
import com.github.bordertech.wcomponents.WLabel;
import com.github.bordertech.wcomponents.WTabSet;
import com.github.bordertech.wcomponents.WTextField;
import com.github.bordertech.wcomponents.test.selenium.WComponentSeleniumTestCase;
import junit.framework.Assert;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class ExampleSeleniumTest
extends WComponentSeleniumTestCase {
    public ExampleSeleniumTest() {
        super((WComponent)new ExampleUI());
    }

    @Test
    public void testDuplicatorWithNoGettersWComponentPathImpl() {
        WebDriver driver = this.getDriver();
        By textFieldPath = this.byWComponentPath("ExampleSeleniumTest$TextDuplicator/WTextField");
        driver.findElement(textFieldPath).sendKeys(new CharSequence[]{"dummy"});
        driver.findElement(this.byWComponentPath("ExampleSeleniumTest$TextDuplicator/WButton[0]")).click();
        Assert.assertEquals((String)"Incorrect text field text after duplicate", (String)"dummydummy", (String)driver.findElement(textFieldPath).getAttribute("value"));
        driver.findElement(this.byWComponentPath("ExampleSeleniumTest$TextDuplicator/WButton[1]")).click();
        Assert.assertEquals((String)"Incorrect text field text after clear", (String)"", (String)driver.findElement(textFieldPath).getAttribute("value"));
    }

    @Test
    public void testDuplicatorWithNoGettersHtmlImpl() {
        WebDriver driver = this.getDriver();
        driver.findElement(By.xpath((String)"//input[@type='text']")).sendKeys(new CharSequence[]{"dummy"});
        driver.findElement(By.xpath((String)"//*[text()='Duplicate']")).click();
        Assert.assertEquals((String)"Incorrect text field text after duplicate", (String)"dummydummy", (String)driver.findElement(By.xpath((String)"//input[@type='text']")).getAttribute("value"));
        driver.findElement(By.xpath((String)"//*[text()='Clear']")).click();
        Assert.assertEquals((String)"Incorrect text field text after clear", (String)"", (String)driver.findElement(By.xpath((String)"//input[@type='text']")).getAttribute("value"));
    }

    @Test
    public void testDuplicatorWithGettersWComponentPathImpl() {
        WebDriver driver = this.getDriver();
        By textFieldPath = this.byWComponentPath("ExampleSeleniumTest$TextDuplicatorWithGetters/WTextField");
        driver.findElement(this.byWComponentPath("WTab[1]")).click();
        driver.findElement(textFieldPath).sendKeys(new CharSequence[]{"dummy"});
        driver.findElement(this.byWComponentPath("ExampleSeleniumTest$TextDuplicatorWithGetters/WButton[0]")).click();
        Assert.assertEquals((String)"Incorrect text field text after duplicate", (String)"dummydummy", (String)driver.findElement(textFieldPath).getAttribute("value"));
        driver.findElement(this.byWComponentPath("ExampleSeleniumTest$TextDuplicatorWithGetters/WButton[1]")).click();
        Assert.assertEquals((String)"Incorrect text field text after clear", (String)"", (String)driver.findElement(textFieldPath).getAttribute("value"));
    }

    @Test
    public void testDuplicatorWithGettersWComponentImpl() {
        WebDriver driver = this.getDriver();
        ExampleUI ui = (ExampleUI)this.getUi();
        WTextField textField = ui.getTextDuplicatorWithGetters().getTextField();
        WButton duplicateButton = ui.getTextDuplicatorWithGetters().getDuplicateButton();
        WButton clearButton = ui.getTextDuplicatorWithGetters().getClearButton();
        driver.findElement(this.byWComponentPath("WTab[1]")).click();
        driver.findElement(this.byWComponent((WComponent)textField)).sendKeys(new CharSequence[]{"dummy"});
        driver.findElement(this.byWComponent((WComponent)duplicateButton)).click();
        Assert.assertEquals((String)"Incorrect text field text after duplicate", (String)"dummydummy", (String)driver.findElement(this.byWComponent((WComponent)textField)).getAttribute("value"));
        driver.findElement(this.byWComponent((WComponent)clearButton)).click();
        Assert.assertEquals((String)"Incorrect text field text after clear", (String)"", (String)driver.findElement(this.byWComponent((WComponent)textField)).getAttribute("value"));
    }

    private static class TextDuplicatorWithGetters
    extends TextDuplicator {
        private TextDuplicatorWithGetters() {
        }

        @Override
        public WTextField getTextField() {
            return super.getTextField();
        }

        @Override
        public WButton getDuplicateButton() {
            return super.getDuplicateButton();
        }

        @Override
        public WButton getClearButton() {
            return super.getClearButton();
        }
    }

    private static class TextDuplicator
    extends WContainer {
        private final WTextField textFld = new WTextField();
        private final WButton duplicateButton = new WButton("Duplicate");
        private final WButton clearButton = new WButton("Clear");

        TextDuplicator() {
            this.duplicateButton.setAction(new Action(){

                public void execute(ActionEvent event) {
                    String text = TextDuplicator.this.textFld.getText();
                    TextDuplicator.this.textFld.setText(text + text);
                }
            });
            this.clearButton.setAction(new Action(){

                public void execute(ActionEvent event) {
                    TextDuplicator.this.textFld.setText("");
                }
            });
            this.add((WComponent)new WLabel("Text to duplicate", (WComponent)this.textFld));
            this.add((WComponent)this.textFld);
            this.add((WComponent)this.duplicateButton);
            this.add((WComponent)this.clearButton);
        }

        WTextField getTextField() {
            return this.textFld;
        }

        WButton getDuplicateButton() {
            return this.duplicateButton;
        }

        WButton getClearButton() {
            return this.clearButton;
        }
    }

    private static final class ExampleUI
    extends WContainer {
        private final TextDuplicator textDuplicator = new TextDuplicator();
        private final TextDuplicatorWithGetters textDuplicatorWithGetters = new TextDuplicatorWithGetters();

        private ExampleUI() {
            WTabSet tabs = new WTabSet();
            this.add((WComponent)tabs);
            tabs.addTab((WComponent)this.textDuplicator, "No getter", WTabSet.TAB_MODE_CLIENT);
            tabs.addTab((WComponent)this.textDuplicatorWithGetters, "With getter", WTabSet.TAB_MODE_LAZY);
        }

        public TextDuplicator getTextDuplicator() {
            return this.textDuplicator;
        }

        public TextDuplicatorWithGetters getTextDuplicatorWithGetters() {
            return this.textDuplicatorWithGetters;
        }
    }
}

