/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium;

import com.github.bordertech.wcomponents.ComponentWithContext;
import com.github.bordertech.wcomponents.UIContext;
import com.github.bordertech.wcomponents.UIContextHolder;
import com.github.bordertech.wcomponents.UIContextImpl;
import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.test.selenium.SeleniumUtil;
import com.github.bordertech.wcomponents.util.TreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByXPath;

public class ByWComponentPath
extends By {
    private final String[] path;
    private final WComponent component;
    private final UIContext context;
    private final Object value;
    private Class<? extends WComponent> componentClass;

    public ByWComponentPath(ComponentWithContext componentWithContext, String path) {
        this(componentWithContext.getComponent(), componentWithContext.getContext(), path);
    }

    public ByWComponentPath(WComponent component, String path) {
        this(component, null, path);
    }

    public ByWComponentPath(WComponent component, UIContext context, String path) {
        this(component, context, path, null);
    }

    public ByWComponentPath(WComponent component, UIContext context, String path, Object value) {
        this.component = component;
        this.context = context == null ? new UIContextImpl() : context;
        this.path = path.split("/");
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElements(SearchContext searchContext) {
        ArrayList<WebElement> result = new ArrayList<WebElement>();
        ComponentWithContext[] components = null;
        UIContextHolder.pushContext((UIContext)this.context);
        try {
            components = TreeUtil.findWComponents((WComponent)this.component, (String[])this.path);
        }
        finally {
            UIContextHolder.popContext();
        }
        if (components.length != 0) {
            this.componentClass = components[0].getComponent().getClass();
        }
        for (ComponentWithContext comp : components) {
            WComponent cmp = comp.getComponent();
            UIContext cmpUic = comp.getContext();
            UIContextHolder.pushContext((UIContext)cmpUic);
            List resultForComp = null;
            try {
                String componentId;
                if (searchContext instanceof FindsById) {
                    componentId = cmp.getId();
                    resultForComp = ((FindsById)searchContext).findElementsById(componentId);
                } else if (searchContext instanceof FindsByName) {
                    String name = cmp.getId();
                    resultForComp = ((FindsByName)searchContext).findElementsByName(name);
                } else {
                    componentId = cmp.getId();
                    resultForComp = ((FindsByXPath)searchContext).findElementsByXPath("*[@id = '" + componentId + "']");
                }
            }
            finally {
                UIContextHolder.popContext();
            }
            if (resultForComp == null) continue;
            SeleniumUtil.narrowResults(resultForComp, cmp, cmpUic, this.value);
            result.addAll(resultForComp);
        }
        return result;
    }

    public String toString() {
        return "ByWComponentPath:" + Arrays.asList(this.path) + (this.value == null ? "" : " with value \"" + this.value + '\"');
    }

    public Class<? extends WComponent> getTargetWComponentClass() {
        return this.componentClass;
    }
}

