/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium;

import com.github.bordertech.wcomponents.test.selenium.WComponentSeleniumTestCase;
import com.github.bordertech.wcomponents.util.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;
import org.junit.runners.model.Statement;

public class MultiBrowserRunner
extends Suite {
    private final List<Runner> runners = new ArrayList<Runner>();
    private static final String BROWSERS_PARAM_KEY = "bordertech.wcomponents.test.selenium.browsers";
    private static final String RUN_PARALLEL_PARAM_KEY = "bordertech.wcomponents.test.selenium.runParallel";

    public MultiBrowserRunner(Class<?> clazz) throws InitializationError {
        super(clazz, Collections.emptyList());
        String[] browsers = Config.getInstance().getStringArray(BROWSERS_PARAM_KEY);
        for (int i = 0; i < browsers.length; ++i) {
            this.runners.add((Runner)new TestClassRunnerForBrowser(this.getTestClass().getJavaClass(), browsers, i));
        }
        boolean runParallel = Config.getInstance().getBoolean(RUN_PARALLEL_PARAM_KEY, false);
        if (runParallel) {
            this.setScheduler(new ThreadPoolScheduler());
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private static final class ThreadPoolScheduler
    implements RunnerScheduler {
        private final ExecutorService executor = Executors.newCachedThreadPool();

        private ThreadPoolScheduler() {
        }

        public void finished() {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(600L, TimeUnit.SECONDS);
            }
            catch (InterruptedException exc) {
                throw new IllegalStateException("Test execution timed out", exc);
            }
        }

        public void schedule(Runnable childStatement) {
            this.executor.submit(childStatement);
        }
    }

    private static final class TestClassRunnerForBrowser
    extends BlockJUnit4ClassRunner {
        private final int parameterIndex;
        private final String[] browsers;

        private TestClassRunnerForBrowser(Class<?> type, String[] browsers, int parameterIndex) throws InitializationError {
            super(type);
            this.browsers = browsers;
            this.parameterIndex = parameterIndex;
        }

        public Object createTest() throws Exception {
            Object test = super.createTest();
            if (test instanceof WComponentSeleniumTestCase) {
                ((WComponentSeleniumTestCase)test).setBrowser(this.browsers[this.parameterIndex]);
            }
            return test;
        }

        protected String getName() {
            return String.format("%s", this.browsers[this.parameterIndex]);
        }

        protected String testName(FrameworkMethod method) {
            return String.format("%s[%s]", method.getName(), this.browsers[this.parameterIndex]);
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }
    }
}

