/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium;

import com.github.bordertech.wcomponents.UIContext;
import com.github.bordertech.wcomponents.UIContextHolder;
import com.github.bordertech.wcomponents.WCollapsible;
import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.WebUtilities;
import com.github.bordertech.wcomponents.test.WComponentTestCase;
import com.github.bordertech.wcomponents.test.selenium.ByWComponent;
import com.github.bordertech.wcomponents.test.selenium.ByWComponentPath;
import com.github.bordertech.wcomponents.test.selenium.SeleniumTestServlet;
import com.github.bordertech.wcomponents.test.selenium.SeleniumTestSetup;
import com.github.bordertech.wcomponents.util.SystemException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class WComponentSeleniumTestCase
extends WComponentTestCase {
    private static final Log LOG = LogFactory.getLog(WComponentSeleniumTestCase.class);
    private static final int IMPLICIT_WAIT = 1000;
    private WebDriver driver;
    private String browser;
    private static int testSequenceNumber = 0;
    private final String testId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WComponentSeleniumTestCase(WComponent ui) {
        super(ui);
        Class<WComponentSeleniumTestCase> clazz = WComponentSeleniumTestCase.class;
        synchronized (WComponentSeleniumTestCase.class) {
            this.testId = this.getClass().getSimpleName() + '.' + testSequenceNumber++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Before
    public void setUp() {
        UIContext uic = this.getUIContext();
        SeleniumTestServlet.setUiContext(this.testId, uic);
        UIContextHolder.reset();
        UIContextHolder.pushContext((UIContext)uic);
        int oldCount = SeleniumTestServlet.getServiceCount();
        this.driver = this.launchBrowser();
        long end = System.currentTimeMillis() + 1000L;
        while (System.currentTimeMillis() < end && oldCount == SeleniumTestServlet.getServiceCount()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ignored) {
                break;
            }
        }
    }

    @After
    public void tearDown() {
        this.resetUIContext();
        SeleniumTestServlet.removeUiContext(this.testId);
        UIContextHolder.reset();
        this.driver.quit();
        this.driver = null;
    }

    @BeforeClass
    public static void startLde() {
        SeleniumTestSetup.startLde();
    }

    @AfterClass
    public static void stopLde() {
        SeleniumTestSetup.stopLde();
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    protected final WebDriver getDriver() {
        return this.driver;
    }

    protected WebDriver createDriver() {
        if ("iexplore".equals(this.browser)) {
            return new MyInternetExplorerDriver();
        }
        if ("firefox".equals(this.browser)) {
            return new MyFirefoxDriver();
        }
        if ("chrome".equals(this.browser)) {
            return new MyChromeDriver();
        }
        return new MyInternetExplorerDriver();
    }

    private WebDriver launchBrowser() {
        this.driver = this.createDriver();
        this.driver.get(SeleniumTestServlet.getServletUrl() + "/" + WebUtilities.escapeForUrl((String)this.testId) + "?selenium-ts=" + System.currentTimeMillis());
        return this.driver;
    }

    protected By byWComponentPath(String path) {
        return new ByWComponentPath((WComponent)this.getWrappedUi(), this.getUIContext(), path);
    }

    protected By byWComponent(WComponent component) {
        return new ByWComponent(component, this.getUIContext());
    }

    protected By byWComponentPath(String path, Object value) {
        return new ByWComponentPath((WComponent)this.getWrappedUi(), this.getUIContext(), path, value);
    }

    protected By byWComponent(WComponent component, Object value) {
        return new ByWComponent(component, this.getUIContext(), value);
    }

    private static void waitForPageReady(JavascriptExecutor driver) {
        long end = System.currentTimeMillis() + 1000L;
        while (System.currentTimeMillis() < end) {
            try {
                Object readyFlag = driver.executeScript("return window.isPageReady && window.isPageReady()", new Object[0]);
                if (Boolean.TRUE.equals(readyFlag)) {
                    LOG.debug((Object)"READY");
                    break;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("STATUS: " + driver.executeScript("return window.isPageReady? window.isPageReady.status() : ''", new Object[0])));
                    LOG.debug((Object)"PAGE NOT READY. WAITING...");
                }
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                break;
            }
            catch (WebDriverException webDriverException) {
            }
        }
    }

    private static final class WebElementWrapper
    implements WebElement {
        private static final int SLEEP_DELAY = 100;
        private final WebElement element;
        private final Class<? extends WComponent> componentClass;
        private final WebDriver driver;

        private WebElementWrapper(WebDriver driver, WebElement element) {
            this(driver, element, (Class<? extends WComponent>)null);
        }

        private WebElementWrapper(WebDriver driver, WebElement element, Class<? extends WComponent> componentClass) {
            this.driver = driver;
            this.element = element;
            this.componentClass = componentClass;
        }

        public void clear() {
            this.element.clear();
            this.sleep();
        }

        public void click() {
            if (WCollapsible.class.equals(this.componentClass)) {
                this.element.findElement(By.xpath((String)".//button")).click();
            } else {
                this.element.click();
            }
            this.sleep();
        }

        public WebElement findElement(By by) {
            return this.element.findElement(by);
        }

        public List<WebElement> findElements(By by) {
            return this.element.findElements(by);
        }

        public String getAttribute(String name) {
            if (this.driver instanceof MyInternetExplorerDriver && "value".equals(name) && "textarea".equals(this.getTagName())) {
                return this.element.getAttribute(name).replaceAll("\r\n", "\n");
            }
            return this.element.getAttribute(name);
        }

        public String getTagName() {
            return this.element.getTagName();
        }

        public String getText() {
            return this.element.getText();
        }

        public boolean isEnabled() {
            return this.element.isEnabled();
        }

        public boolean isSelected() {
            return this.element.isSelected();
        }

        public void sendKeys(CharSequence ... keys) {
            this.element.sendKeys(keys);
            this.sleep();
        }

        public void submit() {
            this.element.submit();
            this.sleep();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sleep() {
            try {
                WebElementWrapper webElementWrapper = this;
                synchronized (webElementWrapper) {
                    this.wait(100L);
                    WComponentSeleniumTestCase.waitForPageReady((JavascriptExecutor)this.driver);
                }
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Interrupted", (Throwable)e);
                throw new SystemException((Throwable)e);
            }
        }

        public boolean isDisplayed() {
            return this.element.isDisplayed();
        }

        public Point getLocation() {
            return this.element.getLocation();
        }

        public Dimension getSize() {
            return this.element.getSize();
        }

        public String getCssValue(String propertyName) {
            return this.element.getCssValue(propertyName);
        }
    }

    private static final class MyChromeDriver
    extends ChromeDriver {
        private MyChromeDriver() {
            super(MyChromeDriver.capabilities());
            this.manage().timeouts().implicitlyWait(1000L, TimeUnit.MILLISECONDS);
        }

        private static Capabilities capabilities() {
            DesiredCapabilities capabilities = DesiredCapabilities.chrome();
            capabilities.setCapability("chrome.switches", Arrays.asList("--start-maximized", "--disable-popup-blocking"));
            return capabilities;
        }

        public List<WebElement> findElements(By by) {
            WComponentSeleniumTestCase.waitForPageReady((JavascriptExecutor)this);
            List elements = super.findElements(by);
            for (int i = 0; i < elements.size(); ++i) {
                elements.set(i, new WebElementWrapper((WebDriver)this, (WebElement)elements.get(i)));
            }
            return elements;
        }

        public WebElement findElement(By by) {
            WComponentSeleniumTestCase.waitForPageReady((JavascriptExecutor)this);
            WebElement element = super.findElement(by);
            if (by instanceof ByWComponent) {
                Class<? extends WComponent> targetClass = ((ByWComponent)by).getTargetWComponentClass();
                return new WebElementWrapper((WebDriver)this, element, targetClass);
            }
            if (by instanceof ByWComponentPath) {
                Class<? extends WComponent> targetClass = ((ByWComponentPath)by).getTargetWComponentClass();
                return new WebElementWrapper((WebDriver)this, element, targetClass);
            }
            return new WebElementWrapper((WebDriver)this, element);
        }
    }

    private static final class MyFirefoxDriver
    extends FirefoxDriver {
        private MyFirefoxDriver() {
            this.manage().timeouts().implicitlyWait(1000L, TimeUnit.MILLISECONDS);
        }

        public List<WebElement> findElements(By by) {
            WComponentSeleniumTestCase.waitForPageReady((JavascriptExecutor)this);
            List elements = super.findElements(by);
            for (int i = 0; i < elements.size(); ++i) {
                elements.set(i, new WebElementWrapper((WebDriver)this, (WebElement)elements.get(i)));
            }
            return elements;
        }

        public WebElement findElement(By by) {
            WComponentSeleniumTestCase.waitForPageReady((JavascriptExecutor)this);
            WebElement element = super.findElement(by);
            if (by instanceof ByWComponent) {
                Class<? extends WComponent> targetClass = ((ByWComponent)by).getTargetWComponentClass();
                return new WebElementWrapper((WebDriver)this, element, targetClass);
            }
            if (by instanceof ByWComponentPath) {
                Class<? extends WComponent> targetClass = ((ByWComponentPath)by).getTargetWComponentClass();
                return new WebElementWrapper((WebDriver)this, element, targetClass);
            }
            return new WebElementWrapper((WebDriver)this, element);
        }
    }

    private static final class MyInternetExplorerDriver
    extends InternetExplorerDriver {
        private MyInternetExplorerDriver() {
            this.manage().timeouts().implicitlyWait(1000L, TimeUnit.MILLISECONDS);
        }

        public List<WebElement> findElements(By by) {
            WComponentSeleniumTestCase.waitForPageReady((JavascriptExecutor)this);
            List elements = super.findElements(by);
            for (int i = 0; i < elements.size(); ++i) {
                elements.set(i, new WebElementWrapper((WebDriver)this, (WebElement)elements.get(i)));
            }
            return elements;
        }

        public WebElement findElement(By by) {
            WComponentSeleniumTestCase.waitForPageReady((JavascriptExecutor)this);
            WebElement element = super.findElement(by);
            if (by instanceof ByWComponent) {
                Class<? extends WComponent> targetClass = ((ByWComponent)by).getTargetWComponentClass();
                return new WebElementWrapper((WebDriver)this, element, targetClass);
            }
            if (by instanceof ByWComponentPath) {
                Class<? extends WComponent> targetClass = ((ByWComponentPath)by).getTargetWComponentClass();
                return new WebElementWrapper((WebDriver)this, element, targetClass);
            }
            return new WebElementWrapper((WebDriver)this, element);
        }
    }
}

