/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium;

import com.github.bordertech.wcomponents.ComponentWithContext;
import com.github.bordertech.wcomponents.UIContext;
import com.github.bordertech.wcomponents.UIContextHolder;
import com.github.bordertech.wcomponents.UIContextImpl;
import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.test.selenium.SeleniumUtil;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByXPath;

public class ByWComponent
extends By {
    private final WComponent component;
    private final UIContext context;
    private final Object value;

    public ByWComponent(ComponentWithContext componentWithContext) {
        this(componentWithContext.getComponent(), componentWithContext.getContext(), null);
    }

    public ByWComponent(WComponent component, UIContext context) {
        this(component, context, null);
    }

    public ByWComponent(WComponent component, UIContext context, Object value) {
        this.component = component;
        this.context = context == null ? new UIContextImpl() : context;
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElements(SearchContext searchContext) {
        List result = new ArrayList();
        UIContextHolder.pushContext((UIContext)this.context);
        try {
            if (searchContext instanceof FindsById) {
                String componentId = this.component.getId();
                result = ((FindsById)searchContext).findElementsById(componentId);
            } else if (searchContext instanceof FindsByName) {
                String name = this.component.getId();
                result = ((FindsByName)searchContext).findElementsByName(name);
            } else {
                String componentId = this.component.getId();
                result = ((FindsByXPath)searchContext).findElementsByXPath("*[@id = '" + componentId + "']");
            }
        }
        finally {
            UIContextHolder.popContext();
        }
        if (result != null) {
            SeleniumUtil.narrowResults(result, this.component, this.context, this.value);
        }
        return result;
    }

    public String toString() {
        return "ByWComponent:" + this.component.getId() + (this.value == null ? "" : " with value \"" + this.value + '\"');
    }

    public Class<? extends WComponent> getTargetWComponentClass() {
        return this.component.getClass();
    }
}

