/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium;

import com.github.bordertech.wcomponents.RenderContext;
import com.github.bordertech.wcomponents.Request;
import com.github.bordertech.wcomponents.UIContext;
import com.github.bordertech.wcomponents.UIContextHolder;
import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.WebComponent;
import com.github.bordertech.wcomponents.WebUtilities;
import com.github.bordertech.wcomponents.container.InterceptorComponent;
import com.github.bordertech.wcomponents.lde.TestServlet;
import com.github.bordertech.wcomponents.servlet.WServlet;
import com.github.bordertech.wcomponents.servlet.WebXmlRenderContext;
import com.github.bordertech.wcomponents.util.Config;
import com.github.bordertech.wcomponents.util.StreamUtil;
import com.github.bordertech.wcomponents.util.SystemException;
import com.github.bordertech.wcomponents.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.webapp.WebAppContext;

public class SeleniumTestServlet
extends TestServlet {
    private static final Map<String, UIContext> CONTEXT_MAP = new HashMap<String, UIContext>();
    private static final SeleniumTestServlet SERVLET = new SeleniumTestServlet();
    private static int serviceCount = 0;
    private static final Object LOCK = new Object();
    protected static final String REQUEST_TEST_CASE_ID_PARAM = "SeleniumTestServlet.seleniumTestId";

    protected void registerServlets(WebAppContext webapp) {
        webapp.addServlet(((Object)((Object)this)).getClass().getName(), "/app/*");
    }

    public InterceptorComponent createInterceptorChain(Object httpServletRequest) {
        InterceptorComponent backing = super.createInterceptorChain(httpServletRequest);
        HttpServletRequest request = (HttpServletRequest)httpServletRequest;
        if (request.getParameter("wc_data") == null && request.getParameter("wc_ajax") == null && request.getParameter("wc_target") == null) {
            ScriptInterceptor seleniumInterceptor = new ScriptInterceptor();
            seleniumInterceptor.setBackingComponent((WebComponent)backing);
            return seleniumInterceptor;
        }
        return backing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        Object object = LOCK;
        synchronized (object) {
            super.service(req, res);
            SeleniumTestServlet.incrementServiceCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void incrementServiceCount() {
        Object object = LOCK;
        synchronized (object) {
            ++serviceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getServiceCount() {
        Object object = LOCK;
        synchronized (object) {
            return serviceCount;
        }
    }

    public static synchronized void setUiContext(String identifier, UIContext uic) {
        CONTEXT_MAP.put(identifier, uic);
    }

    public static synchronized void removeUiContext(String identifier) {
        CONTEXT_MAP.remove(identifier);
    }

    public WComponent getUI(Object httpServletRequest) {
        HttpServletRequest request = (HttpServletRequest)httpServletRequest;
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            String testId = pathInfo.substring(pathInfo.lastIndexOf(47) + 1);
            UIContext uic = CONTEXT_MAP.get(testId);
            if (uic == null) {
                throw new SystemException("Failed to get UIContext from map");
            }
            return uic.getUI();
        }
        return super.getUI(httpServletRequest);
    }

    public static void startServlet() throws Exception {
        SERVLET.run();
    }

    public static void stopServlet() throws InterruptedException {
        SERVLET.stop();
    }

    public static String getServletUrl() {
        return SERVLET.getUrl();
    }

    public void run() throws Exception {
        Config.getInstance().setProperty("bordertech.wcomponents.lde.server.port", (Object)"0");
        super.run();
    }

    protected WServlet.WServletHelper createServletHelper(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return new SeleniumServletHelper((WServlet)this, httpServletRequest, httpServletResponse);
    }

    private static final class ScriptInterceptor
    extends InterceptorComponent {
        private String scriptRequested = null;

        private ScriptInterceptor() {
        }

        public void serviceRequest(Request request) {
            this.scriptRequested = request.getParameter("seleniumTestScript");
            if (Util.empty((String)this.scriptRequested) || this.scriptRequested.indexOf(47) != -1 || !this.scriptRequested.endsWith(".js")) {
                this.scriptRequested = null;
            }
            if (this.scriptRequested == null) {
                super.serviceRequest(request);
            }
        }

        public void preparePaint(Request request) {
            UIContext uic = UIContextHolder.getCurrent();
            if (this.scriptRequested == null) {
                super.preparePaint(request);
                StringBuffer path = new StringBuffer(uic.getEnvironment().getPostPath());
                path.append("?seleniumTestScript=seleniumBefore.js");
                for (Map.Entry entry : uic.getEnvironment().getHiddenParameters().entrySet()) {
                    path.append('&');
                    path.append(WebUtilities.escapeForUrl((String)((String)entry.getKey())));
                    path.append('=');
                    path.append(WebUtilities.escapeForUrl((String)((String)entry.getValue())));
                }
                String pathStr = WebUtilities.encode((String)path.toString());
                uic.getHeaders().addHeadLine("<script type=\"text/javascript\" src=\"" + pathStr + "\"/>");
            } else {
                uic.getHeaders().setContentType("application/x-javascript");
            }
        }

        public void paint(RenderContext renderContext) {
            if (this.scriptRequested == null) {
                super.paint(renderContext);
            } else if (renderContext instanceof WebXmlRenderContext) {
                WebXmlRenderContext webContext = (WebXmlRenderContext)renderContext;
                try {
                    InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/com/github/bordertech/wcomponents/test/selenium/" + this.scriptRequested);
                    webContext.getWriter().write(new String(StreamUtil.getBytes((InputStream)stream), "UTF-8"));
                }
                catch (Exception e) {
                    LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)"Failed to write selenium script", (Throwable)e);
                }
            } else {
                throw new SystemException("Unable to render to " + renderContext);
            }
        }
    }

    private static final class SeleniumServletHelper
    extends WServlet.WServletHelper {
        private final Request request = this.createRequest();
        private final String testId;

        private SeleniumServletHelper(WServlet servlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            super(servlet, httpServletRequest, httpServletResponse);
            String pathInfo = httpServletRequest.getPathInfo();
            this.testId = pathInfo == null ? null : pathInfo.substring(pathInfo.lastIndexOf(47) + 1);
        }

        protected UIContext getUIContext() {
            UIContext uic = super.getUIContext();
            if (uic == null) {
                uic = (UIContext)CONTEXT_MAP.get(this.testId);
                this.getBackingRequest().getSession().setAttribute(this.getUiContextSessionKey(), (Object)uic);
            }
            return uic;
        }

        protected Request getRequest() {
            return this.request;
        }
    }
}

