/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium;

import com.github.bordertech.wcomponents.AbstractWSelectList;
import com.github.bordertech.wcomponents.UIContext;
import com.github.bordertech.wcomponents.UIContextHolder;
import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.WRadioButton;
import com.github.bordertech.wcomponents.WebUtilities;
import com.github.bordertech.wcomponents.util.Util;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public final class SeleniumUtil {
    private SeleniumUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebElement findValue(WebElement current, WComponent component, UIContext context, Object value) {
        if (value == null) {
            return current;
        }
        UIContextHolder.pushContext((UIContext)context);
        try {
            if (component instanceof AbstractWSelectList) {
                AbstractWSelectList list = (AbstractWSelectList)component;
                List options = list.getOptions();
                if (options != null) {
                    for (int i = 0; i < options.size(); ++i) {
                        Object option = options.get(i);
                        if (!Util.equals((Object)value, option) && !Util.equals((Object)value.toString(), (Object)list.getDesc(option, i))) continue;
                        WebElement webElement = current.findElement(By.xpath((String)(".//*[@value='" + list.getCode(option, i) + "']")));
                        return webElement;
                    }
                }
                WebElement webElement = null;
                return webElement;
            }
            if (component instanceof WRadioButton) {
                WebElement webElement = value.equals(((WRadioButton)component).getValue()) ? current : null;
                return webElement;
            }
            WebElement webElement = current.findElement(By.xpath((String)(".//*[@value='" + WebUtilities.encode((String)String.valueOf(value)) + "']")));
            return webElement;
        }
        finally {
            UIContextHolder.popContext();
        }
    }

    protected static void narrowResults(List<WebElement> results, WComponent component, UIContext context, Object value) {
        if (value != null) {
            for (int i = 0; i < results.size(); ++i) {
                WebElement narrowed = SeleniumUtil.findValue(results.get(i), component, context, value);
                if (narrowed == null) {
                    results.remove(i--);
                    continue;
                }
                results.set(i, narrowed);
            }
        }
    }
}

