/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import junit.framework.AssertionFailedError;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.Validator;
import org.custommonkey.xmlunit.XMLUnit;
import org.xml.sax.SAXException;

public final class ValidatorApp
extends JFrame {
    private final JTextArea in = new JTextArea(25, 80);
    private final JTextArea out = new JTextArea(10, 80);

    public ValidatorApp() {
        super("Theme 2x XHTML Validator");
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        this.in.setLineWrap(true);
        this.in.setWrapStyleWord(true);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)new JLabel("XML to validate:"), "North");
        JScrollPane scrollPane = new JScrollPane(20, 31);
        scrollPane.getViewport().add(this.in);
        topPanel.add((Component)scrollPane, "Center");
        JButton validateButton = new JButton("Validate");
        validateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ValidatorApp.this.validateXml();
            }
        });
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)validateButton, "North");
        bottomPanel.add((Component)new JScrollPane(this.out), "Center");
        this.getContentPane().add((Component)topPanel, "Center");
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    private void validateXml() {
        String xhtml = this.in.getText();
        try {
            this.assertSchemaMatch(xhtml);
            this.out.setText("Valid!");
            this.out.setCaretPosition(0);
        }
        catch (AssertionFailedError error) {
            this.out.setText(error.getMessage().replaceAll("cvc-complex-type.2.4.a:", "\n").trim());
            this.out.setCaretPosition(0);
        }
        catch (Exception e) {
            this.out.setText(e.getMessage());
        }
    }

    public void assertSchemaMatch(String xhtml) throws SAXException {
        String schema = this.getClass().getResource("/schema/ui/v1/schema.xsd").toString();
        StringReader reader = new StringReader(xhtml);
        Validator validator = new Validator((Reader)reader);
        validator.useXMLSchema(true);
        validator.setJAXP12SchemaSource((Object)schema);
        validator.assertIsValid();
    }

    public static void main(String[] args) {
        NamespaceContext context = XMLUnit.getXpathNamespaceContext();
        context = new XmlLayoutTestNamespaceContext(context);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)context);
        new ValidatorApp();
    }

    private static final class XmlLayoutTestNamespaceContext
    implements NamespaceContext {
        private final NamespaceContext backing;

        XmlLayoutTestNamespaceContext(NamespaceContext backing) {
            this.backing = backing;
        }

        public String getNamespaceURI(String prefix) {
            if ("ui".equals(prefix)) {
                return "https://github.com/bordertech/wcomponents/namespace/ui/v1.0";
            }
            if ("html".equals(prefix)) {
                return "http://www.w3.org/1999/xhtml";
            }
            if (this.backing != null) {
                return this.backing.getNamespaceURI(prefix);
            }
            return null;
        }

        public Iterator<String> getPrefixes() {
            HashSet<String> prefixes = new HashSet<String>(2);
            prefixes.add("ui");
            prefixes.add("html");
            if (this.backing != null) {
                Iterator i = this.backing.getPrefixes();
                while (i.hasNext()) {
                    prefixes.add((String)i.next());
                }
            }
            return prefixes.iterator();
        }
    }
}

