/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium;

import com.github.bordertech.wcomponents.test.selenium.SeleniumWComponentsUtil;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentInputWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByXPath;

public class ByLabel
extends By {
    public static final String XPATH_LABEL_TEXT_EXACT_ROOT = "//span[text()='%1$s']|//label[text()='%1$s']|//legend[text()='%1$s']";
    public static final String XPATH_LABEL_TEXT_CONTAINS_ROOT = "//span[contains(text(),'%1$s')]|//label[contains(text(),'%1$s')]|//legend[contains(text(),'%1$s')]";
    public static final String XPATH_LABEL_TEXT_EXACT_RELATIVE = ".//span[text()='%1$s']|.//label[text()='%1$s']|.//legend[text()='%1$s']";
    public static final String XPATH_LABEL_TEXT_CONTAINS_RELATIVE = ".//span[contains(text(),'%1$s')]|.//label[contains(text(),'%1$s')]|.//legend[contains(text(),'%1$s')]";
    private final String labelId;
    private final String labelText;
    private final boolean partialMatch;
    private static final String OPTION_INNER_SPAN_CLASSNAME = "wc-labeltext";
    private final boolean relative;

    public ByLabel(String labelId) {
        this.labelId = labelId;
        this.labelText = null;
        this.partialMatch = false;
        this.relative = false;
    }

    public ByLabel(String labelText, boolean partialMatch, boolean relative) {
        this.labelText = labelText;
        this.labelId = null;
        this.partialMatch = partialMatch;
        this.relative = relative;
    }

    public ByLabel(String labelText, boolean partialMatch) {
        this(labelText, partialMatch, false);
    }

    public List<WebElement> findElements(SearchContext context) {
        List labels;
        if (this.labelId != null) {
            labels = ((FindsById)context).findElementsById(this.labelId);
        } else {
            String xpath = this.partialMatch ? String.format(this.relative ? XPATH_LABEL_TEXT_CONTAINS_RELATIVE : XPATH_LABEL_TEXT_CONTAINS_ROOT, this.labelText) : String.format(this.relative ? XPATH_LABEL_TEXT_EXACT_RELATIVE : XPATH_LABEL_TEXT_EXACT_ROOT, this.labelText);
            labels = ((FindsByXPath)context).findElementsByXPath(xpath);
        }
        if (CollectionUtils.isEmpty((Collection)labels)) {
            return labels;
        }
        ArrayList<WebElement> results = new ArrayList<WebElement>();
        for (WebElement label : labels) {
            if ("legend".equalsIgnoreCase(label.getTagName())) {
                results.add(label.findElement(By.xpath((String)"..")));
                continue;
            }
            String elementId = label.getAttribute(SeleniumWComponentWebProperties.ATTRIBUTE_LABEL_FOR.toString());
            if (StringUtils.isEmpty((CharSequence)elementId)) {
                elementId = label.getAttribute(SeleniumWComponentWebProperties.ATTRIBUTE_LABEL_FAUX_FOR.toString());
            }
            if (StringUtils.isEmpty((CharSequence)elementId)) {
                elementId = label.getAttribute(SeleniumWComponentWebProperties.ATTRIBUTE_LABEL_FOR_READ_ONLY.toString());
            }
            if ("span".equalsIgnoreCase(label.getTagName()) && OPTION_INNER_SPAN_CLASSNAME.equals(label.getAttribute("class"))) {
                label = label.findElement(By.xpath((String)".."));
            }
            if (StringUtils.isEmpty((CharSequence)elementId)) {
                if (!"label".equalsIgnoreCase(label.getTagName())) continue;
                WebElement nestedElement = label.findElement(By.tagName((String)"input"));
                if (nestedElement == null) {
                    nestedElement = label.findElement(By.tagName((String)"select"));
                }
                if (nestedElement == null) {
                    nestedElement = label.findElement(By.tagName((String)"textarea"));
                }
                if (nestedElement == null) continue;
                results.add(nestedElement);
                continue;
            }
            WebElement element = ((FindsById)context).findElementById(elementId);
            if (elementId.endsWith(SeleniumWComponentWebProperties.ID_SUFFIX.toString())) {
                SeleniumWComponentInputWebElement wrapped = SeleniumWComponentsUtil.wrapInputElementWithTypedWebElement((WebDriver)context, element);
                results.add(wrapped);
                continue;
            }
            results.add(element);
        }
        return results;
    }
}

