/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium;

import com.github.bordertech.wcomponents.ComponentWithContext;
import com.github.bordertech.wcomponents.UIContext;
import com.github.bordertech.wcomponents.UIContextHolder;
import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.test.selenium.ByWComponent;
import com.github.bordertech.wcomponents.util.TreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ByWComponentPath
extends ByWComponent {
    private final boolean visibleOnly;
    private final String[] path;
    private Class<? extends WComponent> componentClass;

    public ByWComponentPath(ComponentWithContext componentWithContext, String path) {
        this(componentWithContext.getComponent(), componentWithContext.getContext(), path);
    }

    public ByWComponentPath(ComponentWithContext componentWithContext, String path, boolean visibleOnly) {
        this(componentWithContext.getComponent(), componentWithContext.getContext(), path, visibleOnly);
    }

    public ByWComponentPath(WComponent component, String path) {
        this(component, null, path);
    }

    public ByWComponentPath(WComponent component, String path, boolean visibleOnly) {
        this(component, (UIContext)null, path, visibleOnly);
    }

    public ByWComponentPath(WComponent component, UIContext context, String path) {
        this(component, context, path, null);
    }

    public ByWComponentPath(WComponent component, UIContext context, String path, boolean visibleOnly) {
        this(component, context, path, null, visibleOnly);
    }

    public ByWComponentPath(WComponent component, UIContext context, String path, Object value) {
        this(component, context, path, value, true);
    }

    public ByWComponentPath(WComponent component, UIContext context, String path, Object value, boolean visibleOnly) {
        super(component, context, value);
        this.path = path.split("/");
        this.visibleOnly = visibleOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WebElement> findElements(SearchContext searchContext) {
        ArrayList<WebElement> result = new ArrayList<WebElement>();
        ComponentWithContext[] components = null;
        UIContextHolder.pushContext((UIContext)this.getContext());
        try {
            components = TreeUtil.findWComponents((WComponent)this.getComponent(), (String[])this.path, (boolean)this.visibleOnly);
        }
        finally {
            UIContextHolder.popContext();
        }
        if (components.length != 0) {
            this.componentClass = components[0].getComponent().getClass();
        }
        for (ComponentWithContext comp : components) {
            WComponent cmp = comp.getComponent();
            UIContext cmpUic = comp.getContext();
            UIContextHolder.pushContext((UIContext)cmpUic);
            try {
                List<WebElement> resultForComp = this.findElement(searchContext, cmpUic, cmp, this.getValue());
                result.addAll(resultForComp);
            }
            finally {
                UIContextHolder.popContext();
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return "ByWComponentPath:" + Arrays.asList(this.path) + (this.getValue() == null ? "" : " with value \"" + this.getValue() + '\"');
    }

    @Override
    public Class<? extends WComponent> getTargetWComponentClass() {
        return this.componentClass;
    }
}

