/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium;

import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriver;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWCheckBoxWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentInputWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWDialogWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWEmailFieldWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWRadioButtonWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWSelectWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWTextAreaWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWTextFieldWebElement;
import com.github.bordertech.wcomponents.util.ConfigurationProperties;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.BooleanUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public final class SeleniumWComponentsUtil {
    private static final String DATA_READY_TAG = ConfigurationProperties.getTestSeleniumDataReadyTag();
    private static final int PAGE_READY_WAIT_TIMEOUT = ConfigurationProperties.getTestSeleniumPageReadyTimeout();
    private static final long PAGE_READY_POLL_INTERVAL = ConfigurationProperties.getTestSeleniumPageReadyPollInterval();
    private static final long IMPLICIT_WAIT_SECONDS = ConfigurationProperties.getTestSeleniumImplicitWait();
    private static final int SCREEN_WIDTH = ConfigurationProperties.getTestSeleniumScreenWidth();
    private static final int SCREEN_HEIGHT = ConfigurationProperties.getTestSeleniumScreenHeight();
    private static final ExpectedCondition<Boolean> PAGE_WAIT_CONDITION = new ExpectedCondition<Boolean>(){

        public Boolean apply(WebDriver driver) {
            boolean domReady;
            if (driver == null) {
                throw new IllegalArgumentException("a driver must be provided.");
            }
            try {
                WebElement body;
                if (driver instanceof SeleniumWComponentsWebDriver) {
                    SeleniumWComponentsWebDriver wcDriver = (SeleniumWComponentsWebDriver)driver;
                    body = wcDriver.findElement(By.tagName((String)"body"), false);
                } else {
                    body = driver.findElement(By.tagName((String)"body"));
                }
                String domReadyAttr = body.getAttribute(DATA_READY_TAG);
                domReady = BooleanUtils.isNotFalse((Boolean)BooleanUtils.toBooleanObject((String)domReadyAttr));
            }
            catch (StaleElementReferenceException e) {
                domReady = false;
            }
            return domReady;
        }
    };

    public static void configureDriver(WebDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("a driver must be provided.");
        }
        SeleniumWComponentsUtil.configureImplicitWait(driver);
        driver.manage().window().setSize(new Dimension(SCREEN_WIDTH, SCREEN_HEIGHT));
    }

    public static void configureImplicitWait(WebDriver driver) {
        SeleniumWComponentsUtil.configureImplicitWait(driver, IMPLICIT_WAIT_SECONDS, TimeUnit.SECONDS);
    }

    public static void configureImmediateImplicitWait(WebDriver driver) {
        if (IMPLICIT_WAIT_SECONDS != 0L) {
            SeleniumWComponentsUtil.configureImplicitWait(driver, 0L, TimeUnit.MILLISECONDS);
        }
    }

    public static void configureImplicitWait(WebDriver driver, long time, TimeUnit unit) {
        driver.manage().timeouts().implicitlyWait(time, unit);
    }

    public static void waitForPageReady(WebDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("a driver must be provided.");
        }
        SeleniumWComponentsUtil.waitForPageReady(driver, PAGE_READY_WAIT_TIMEOUT, PAGE_READY_POLL_INTERVAL);
    }

    public static void waitForPageReady(WebDriver driver, int timeoutSeconds, long pollingMilliseconds) {
        if (driver == null) {
            throw new IllegalArgumentException("a driver must be provided.");
        }
        WebDriverWait wait = new WebDriverWait(driver, (long)timeoutSeconds, pollingMilliseconds);
        wait.until(SeleniumWComponentsUtil.getPageReadyCondition());
    }

    public static boolean isOpenDialog(WebDriver driver) {
        try {
            By by = By.cssSelector((String)SeleniumWDialogWebElement.getOpenDialogCssSelector());
            WebElement element = SeleniumWComponentsUtil.findElementImmediateForDriver(driver, by);
            return element != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public static SeleniumWDialogWebElement getDialog(WebDriver driver) {
        By by = By.cssSelector((String)SeleniumWDialogWebElement.getOpenDialogCssSelector());
        WebElement dialog = SeleniumWComponentsUtil.findElementImmediateForDriver(driver, by);
        return dialog == null ? null : new SeleniumWDialogWebElement(dialog, driver);
    }

    public static ExpectedCondition<Boolean> getPageReadyCondition() {
        return PAGE_WAIT_CONDITION;
    }

    public static SeleniumWComponentInputWebElement wrapInputElementWithTypedWebElement(WebDriver driver, WebElement element) {
        String tag = element.getTagName();
        if (tag.equals("input")) {
            String type = element.getAttribute("type");
            WebElement el = element.findElement(By.xpath((String)".."));
            switch (type) {
                case "checkbox": {
                    return new SeleniumWCheckBoxWebElement(el, driver);
                }
                case "text": {
                    return new SeleniumWTextFieldWebElement(el, driver);
                }
                case "email": {
                    return new SeleniumWEmailFieldWebElement(el, driver);
                }
                case "radio": {
                    return new SeleniumWRadioButtonWebElement(el, driver);
                }
            }
            return new SeleniumWComponentInputWebElement(el, driver);
        }
        if (tag.equals("textarea")) {
            return new SeleniumWTextAreaWebElement(element.findElement(By.xpath((String)"..")), driver);
        }
        if (tag.equals("select")) {
            return new SeleniumWSelectWebElement(element.findElement(By.xpath((String)"..")), driver);
        }
        return new SeleniumWComponentInputWebElement(element, driver);
    }

    public static WebElement findElementImmediateForDriver(WebDriver driver, By by) {
        if (driver instanceof SeleniumWComponentsWebDriver) {
            return ((SeleniumWComponentsWebDriver)driver).findElementImmediate(by);
        }
        return driver.findElement(by);
    }

    public static List<WebElement> findElementsImmediateForDriver(WebDriver driver, By by) {
        if (driver instanceof SeleniumWComponentsWebDriver) {
            return ((SeleniumWComponentsWebDriver)driver).findElementsImmediate(by);
        }
        return driver.findElements(by);
    }

    public static WebElement findElementImmediateForElement(WebElement element, By by) {
        if (element instanceof SeleniumWComponentWebElement) {
            return ((SeleniumWComponentWebElement)element).findElementImmediate(by);
        }
        return element.findElement(by);
    }

    public static List<WebElement> findElementsImmediateForElement(WebElement element, By by) {
        if (element instanceof SeleniumWComponentWebElement) {
            return ((SeleniumWComponentWebElement)element).findElementsImmediate(by);
        }
        return element.findElements(by);
    }

    private SeleniumWComponentsUtil() {
    }
}

