/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium;

import com.github.bordertech.wcomponents.UIContext;
import com.github.bordertech.wcomponents.test.selenium.driver.ParameterizedWebDriverType;
import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriver;
import com.github.bordertech.wcomponents.test.selenium.driver.WebDriverCache;
import com.github.bordertech.wcomponents.test.selenium.driver.WebDriverType;
import com.github.bordertech.wcomponents.test.selenium.server.ServerCache;
import com.github.bordertech.wcomponents.util.ConfigurationProperties;
import com.github.bordertech.wcomponents.util.SystemException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class WComponentSeleniumTestCase {
    private static final Log LOG = LogFactory.getLog(WComponentSeleniumTestCase.class);
    private WebDriverType driverType;
    private String driverId = null;
    private String url;
    private SeleniumWComponentsWebDriver driver;

    public WComponentSeleniumTestCase() {
        this(true);
    }

    public WComponentSeleniumTestCase(boolean useDefaultDriver) {
        this(useDefaultDriver, null);
    }

    public WComponentSeleniumTestCase(boolean useDefaultDriver, String url) {
        if (useDefaultDriver) {
            this.driverType = new ParameterizedWebDriverType(this.getClass().getName());
        }
        this.url = url;
        this.configureUrlAndServerFromConfig();
    }

    public WComponentSeleniumTestCase(WebDriverType driverType) {
        this(driverType, null);
    }

    public WComponentSeleniumTestCase(WebDriverType driverType, String driverId) {
        this(driverType, driverId, null);
    }

    public WComponentSeleniumTestCase(WebDriverType driverType, String driverId, String url) {
        if (driverType == null) {
            throw new IllegalArgumentException("driverType must not be null");
        }
        this.driverType = driverType;
        this.driverId = driverId;
        this.url = url;
        this.configureUrlAndServerFromConfig();
    }

    public String getDriverId() {
        return this.driverId;
    }

    public WebDriverType getDriverType() {
        return this.driverType;
    }

    private boolean isConfigureUrlFromConfig() {
        return StringUtils.isBlank((CharSequence)this.url);
    }

    private void configureUrlAndServerFromConfig() {
        if (!this.isConfigureUrlFromConfig()) {
            return;
        }
        String testClassName = this.getClass().getName();
        if (ConfigurationProperties.getTestSeleniumServerStart((String)testClassName)) {
            ServerCache.startServer();
            this.url = ServerCache.getUrl();
        } else {
            this.url = ConfigurationProperties.getTestSeleniumServerUrl((String)testClassName);
        }
    }

    private void launchDriver() {
        if (this.driver == null) {
            if (this.driverType == null) {
                throw new SystemException("Attempted to launch driver prior to configuring the driverType.");
            }
            if (StringUtils.isBlank((CharSequence)this.url)) {
                throw new SystemException("Attempted to launch driver prior to configuring the url.");
            }
            this.driver = this.getDriverWithoutLaunching();
            try {
                if (this.driver.hasSession()) {
                    this.driver.newSession(this.getUrl());
                } else {
                    this.driver.get(this.getUrl());
                }
            }
            catch (Exception e) {
                try {
                    WebDriverCache.closeDriver(this.driverType, this.driverId);
                }
                finally {
                    this.driver = null;
                }
                throw new SystemException("Could not launch the driver. " + e.getMessage());
            }
        }
    }

    public void setDriver(WebDriverType driverType, String driverId) {
        if (driverType == null) {
            throw new IllegalArgumentException("driverType must not be null");
        }
        this.driverType = driverType;
        this.driverId = driverId;
        this.driver = null;
    }

    public void setUrl(String url) {
        this.url = url;
        this.driver = null;
    }

    public String getUrl() {
        return this.url;
    }

    public SeleniumWComponentsWebDriver getDriver() {
        if (this.driverType == null) {
            throw new IllegalArgumentException("driverType must not be null. Ensure the correct constructor was called or the setter has been invoked.");
        }
        if (this.driver == null) {
            this.launchDriver();
        }
        return this.driver;
    }

    public SeleniumWComponentsWebDriver getDriverWithoutLaunching() {
        if (this.driverType == null) {
            throw new IllegalArgumentException("driverType must not be null. Ensure the correct constructor was called or the setter has been invoked.");
        }
        if (StringUtils.isBlank((CharSequence)this.driverId)) {
            return WebDriverCache.getDriver(this.driverType);
        }
        return WebDriverCache.getDriver(this.driverType, this.driverId);
    }

    public void releaseDriver() {
        if (this.driver == null) {
            return;
        }
        if (this.driver.hasSession()) {
            try {
                this.driver.clearUserContext();
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not clear User Session. Will not use driver any more." + e.getMessage()), (Throwable)e);
                try {
                    WebDriverCache.closeDriver(this.driverType, this.driverId);
                }
                catch (Exception e2) {
                    LOG.warn((Object)("Could not close the driver. Will not use driver any more. " + e2.getMessage()), (Throwable)e2);
                }
                this.driver = null;
                return;
            }
        }
        WebDriverCache.releaseDriver(this.driverType, this.driverId);
        this.driver = null;
    }

    public UIContext getUserContextForSession() {
        return this.driver == null ? null : this.driver.getUserContextForSession();
    }
}

